/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.vfs2.FileExtensionSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class FileExtensionSelectorTest {
    private static FileObject baseFolder;
    private static final int FILE_COUNT = 9;
    private static final int EXTENSION_COUNT = 3;
    private static final int FILES_PER_EXTENSION_COUNT = 3;

    @BeforeAll
    public static void setUpClass() throws Exception {
        baseFolder = VFS.getManager().resolveFile("ram://" + FileExtensionSelectorTest.class.getName());
        baseFolder.deleteAll();
        baseFolder.createFolder();
        baseFolder.resolveFile("a.htm").createFile();
        baseFolder.resolveFile("a.html").createFile();
        baseFolder.resolveFile("a.xhtml").createFile();
        baseFolder.resolveFile("b.htm").createFile();
        baseFolder.resolveFile("b.html").createFile();
        baseFolder.resolveFile("b.xhtml").createFile();
        baseFolder.resolveFile("c.htm").createFile();
        baseFolder.resolveFile("c.html").createFile();
        baseFolder.resolveFile("c.xhtml").createFile();
    }

    @AfterAll
    public static void tearDownClass() throws Exception {
        if (baseFolder != null) {
            baseFolder.deleteAll();
        }
    }

    @Test
    public void testEmpty() throws Exception {
        FileExtensionSelector selector = new FileExtensionSelector(new String[0]);
        FileObject[] foList = baseFolder.findFiles((FileSelector)selector);
        Assertions.assertEquals((int)0, (int)foList.length);
    }

    @Test
    public void testManyExtensions() throws Exception {
        FileObject[] foArray = baseFolder.findFiles(Selectors.SELECT_FILES);
        Assertions.assertTrue((foArray.length > 0 ? 1 : 0) != 0);
        HashSet<String> extensionSet = new HashSet<String>();
        for (FileObject fo : foArray) {
            extensionSet.add(fo.getName().getExtension());
        }
        String message = String.format("Extensions: %s; files: %s", ((Object)extensionSet).toString(), Arrays.asList(foArray).toString());
        Assertions.assertFalse((boolean)extensionSet.isEmpty(), (String)message);
        Assertions.assertEquals((int)3, (int)extensionSet.size(), (String)message);
        FileExtensionSelector selector = new FileExtensionSelector(extensionSet);
        FileObject[] list = baseFolder.findFiles((FileSelector)selector);
        Assertions.assertEquals((int)9, (int)list.length);
    }

    @Test
    public void testNullCollection() throws Exception {
        FileExtensionSelector selector0 = new FileExtensionSelector((Collection)null);
        FileObject[] foList = baseFolder.findFiles((FileSelector)selector0);
        Assertions.assertEquals((int)0, (int)foList.length);
    }

    @Test
    public void testNullString() throws Exception {
        FileExtensionSelector selector0 = new FileExtensionSelector(new String[]{null});
        FileObject[] foList = baseFolder.findFiles((FileSelector)selector0);
        Assertions.assertEquals((int)0, (int)foList.length);
    }

    @Test
    public void testOneExtension() throws Exception {
        FileObject[] foArray = baseFolder.findFiles(Selectors.SELECT_FILES);
        Assertions.assertTrue((foArray.length > 0 ? 1 : 0) != 0);
        HashSet<String> extensionSet = new HashSet<String>();
        for (FileObject fo : foArray) {
            extensionSet.add(fo.getName().getExtension());
        }
        String message = String.format("Extensions: %s; files: %s", ((Object)extensionSet).toString(), Arrays.asList(foArray).toString());
        Assertions.assertEquals((int)3, (int)extensionSet.size(), (String)message);
        for (String extension : extensionSet) {
            FileExtensionSelector selector = new FileExtensionSelector(new String[]{extension});
            FileObject[] list = baseFolder.findFiles((FileSelector)selector);
            Assertions.assertEquals((int)3, (int)list.length);
        }
        for (FileObject fo : foArray) {
            FileExtensionSelector selector = new FileExtensionSelector(new String[]{fo.getName().getExtension()});
            FileObject[] list = baseFolder.findFiles((FileSelector)selector);
            Assertions.assertEquals((int)3, (int)list.length);
        }
    }
}

