/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.action;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.ModuleException;

public class ExceptionHandler {
    public static final String INCLUDE_PATH = "INCLUDE_PATH";
    public static final String SILENT_IF_COMMITTED = "SILENT_IF_COMMITTED";
    private static final Log LOG = LogFactory.getLog(ExceptionHandler.class);
    private static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.action.LocalStrings");

    public ActionForward execute(Exception ex, ExceptionConfig ae, ActionMapping mapping, ActionForm formInstance, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String property;
        ActionMessage error;
        LOG.debug("ExceptionHandler executing for exception " + ex);
        ActionForward forward = ae.getPath() != null ? new ActionForward(ae.getPath()) : mapping.getInputForward();
        if (ex instanceof ModuleException) {
            error = ((ModuleException)ex).getActionMessage();
            property = ((ModuleException)ex).getProperty();
        } else {
            error = new ActionMessage(ae.getKey(), ex.getMessage());
            property = error.getKey();
        }
        this.logException(ex);
        request.setAttribute("org.apache.struts.action.EXCEPTION", (Object)ex);
        this.storeException(request, property, error, forward, ae.getScope());
        if (!response.isCommitted()) {
            return forward;
        }
        LOG.debug("Response is already committed, so forwarding will not work. Attempt alternate handling.");
        if (!this.silent(ae)) {
            this.handleCommittedResponse(ex, ae, mapping, formInstance, request, response, forward);
        } else {
            LOG.warn("ExceptionHandler configured with SILENT_IF_COMMITTED and response is committed.", ex);
        }
        return null;
    }

    protected void handleCommittedResponse(Exception ex, ExceptionConfig config, ActionMapping mapping, ActionForm formInstance, HttpServletRequest request, HttpServletResponse response, ActionForward actionForward) {
        String includePath = this.determineIncludePath(config, actionForward);
        if (includePath != null) {
            if (includePath.startsWith("/")) {
                LOG.debug("response committed, but attempt to include results of actionForward path");
                RequestDispatcher requestDispatcher = request.getRequestDispatcher(includePath);
                try {
                    requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                catch (IOException e) {
                    LOG.error("IOException when trying to include the error page path " + includePath, e);
                }
                catch (ServletException e) {
                    LOG.error("ServletException when trying to include the error page path " + includePath, e);
                }
            } else {
                LOG.warn("Suspicious includePath doesn't seem likely to work, so skipping it: " + includePath + "; expected path to start with '/'");
            }
        }
        LOG.debug("Include not available or failed; try writing to the response directly.");
        try {
            response.getWriter().println("Unexpected error: " + ex);
            response.getWriter().println("<!-- ");
            ex.printStackTrace(response.getWriter());
            response.getWriter().println("-->");
        }
        catch (IOException e) {
            LOG.error("Error giving minimal information about exception", e);
            LOG.error("Original exception: ", ex);
        }
    }

    protected String determineIncludePath(ExceptionConfig config, ActionForward actionForward) {
        String includePath = config.getProperty(INCLUDE_PATH);
        if (includePath == null) {
            includePath = actionForward.getPath();
        }
        return includePath;
    }

    protected void logException(Exception e) {
        LOG.debug(messages.getMessage("exception.LOG"), e);
    }

    protected void storeException(HttpServletRequest request, String property, ActionMessage error, ActionForward forward, String scope) {
        ActionMessages errors = new ActionMessages();
        errors.add(property, error);
        if ("request".equals(scope)) {
            request.setAttribute("org.apache.struts.action.ERROR", (Object)errors);
        } else {
            request.getSession().setAttribute("org.apache.struts.action.ERROR", (Object)errors);
        }
    }

    private boolean silent(ExceptionConfig config) {
        return "true".equals(config.getProperty(SILENT_IF_COMMITTED));
    }
}

