/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.ContentEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweEncryption;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rs.security.jose.jwk.KeyOperation;
import org.apache.cxf.rs.security.jose.jws.JwsJsonProducer;

public class AbstractJweJsonWriterProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractJweJsonWriterProvider.class);
    private List<JweEncryptionProvider> encProviders;

    public void setEncryptionProvider(JweEncryptionProvider provider) {
        this.setEncryptionProviders(Collections.singletonList(provider));
    }

    public void setEncryptionProviders(List<JweEncryptionProvider> providers) {
        this.encProviders = providers;
    }

    protected List<String> getPropertyLocations() {
        List<String> propLocs;
        Message m = JAXRSUtils.getCurrentMessage();
        Object propLocsProp = MessageUtils.getContextualProperty((Message)m, (String)"rs.security.encryption.out.properties", (String)"rs.security.encryption.properties");
        if (propLocsProp == null) {
            if (this.encProviders == null) {
                LOG.warning("JWE JSON init properties resource is not identified");
                throw new JweException(JweException.Error.NO_INIT_PROPERTIES);
            }
            return Collections.emptyList();
        }
        if (propLocsProp instanceof String) {
            String[] props = ((String)propLocsProp).split(",");
            propLocs = Arrays.asList(props);
        } else {
            propLocs = CastUtils.cast((List)((List)propLocsProp));
        }
        return propLocs;
    }

    protected List<JweEncryptionProvider> getInitializedEncryptionProviders(List<String> propLocs, JweHeaders sharedProtectedHeaders, List<JweHeaders> perRecipientUnprotectedHeaders) {
        JweEncryption encProvider;
        if (this.encProviders != null) {
            return this.encProviders;
        }
        Message m = JAXRSUtils.getCurrentMessage();
        ArrayList<Properties> propsList = new ArrayList<Properties>(propLocs.size());
        for (int i = 0; i < propLocs.size(); ++i) {
            propsList.add(JweUtils.loadJweProperties((Message)m, (String)propLocs.get(i)));
        }
        ContentAlgorithm ctAlgo = null;
        HashSet<KeyAlgorithm> keyAlgos = new HashSet<KeyAlgorithm>();
        LinkedList<KeyEncryptionProvider> keyProviders = new LinkedList<KeyEncryptionProvider>();
        for (int i = 0; i < propLocs.size(); ++i) {
            Properties props = (Properties)propsList.get(i);
            ContentAlgorithm currentCtAlgo = JweUtils.getContentEncryptionAlgorithm((Message)m, (Properties)props, (ContentAlgorithm)ContentAlgorithm.A128GCM);
            if (ctAlgo == null) {
                ctAlgo = currentCtAlgo;
            } else if (currentCtAlgo != null && !ctAlgo.equals((Object)currentCtAlgo)) {
                throw new JweException(JweException.Error.INVALID_CONTENT_ALGORITHM);
            }
            JweHeaders perRecipientUnprotectedHeader = perRecipientUnprotectedHeaders.get(i);
            KeyEncryptionProvider keyEncryptionProvider = JweUtils.loadKeyEncryptionProvider((Properties)props, (Message)m, (JweHeaders)perRecipientUnprotectedHeader);
            if (keyEncryptionProvider.getAlgorithm() == KeyAlgorithm.DIRECT && propLocs.size() > 1) {
                throw new JweException(JweException.Error.INVALID_JSON_JWE);
            }
            keyProviders.add(keyEncryptionProvider);
            keyAlgos.add(perRecipientUnprotectedHeader.getKeyEncryptionAlgorithm());
        }
        if (ctAlgo == null) {
            throw new JweException(JweException.Error.INVALID_CONTENT_ALGORITHM);
        }
        sharedProtectedHeaders.setContentEncryptionAlgorithm(ctAlgo);
        LinkedList<JweEncryptionProvider> theEncProviders = new LinkedList<JweEncryptionProvider>();
        if (keyProviders.size() == 1 && ((KeyEncryptionProvider)keyProviders.get(0)).getAlgorithm() == KeyAlgorithm.DIRECT) {
            JsonWebKey jwk = JwkUtils.loadJsonWebKey((Message)m, (Properties)((Properties)propsList.get(0)), (KeyOperation)KeyOperation.ENCRYPT);
            if (jwk != null) {
                ContentEncryptionProvider ctProvider = JweUtils.getContentEncryptionProvider((JsonWebKey)jwk, (ContentAlgorithm)ctAlgo);
                encProvider = new JweEncryption((KeyEncryptionProvider)keyProviders.get(0), ctProvider);
                theEncProviders.add((JweEncryptionProvider)encProvider);
            }
        } else {
            ContentEncryptionProvider ctProvider = JweUtils.getContentEncryptionProvider((ContentAlgorithm)ctAlgo, (boolean)true);
            for (int i = 0; i < keyProviders.size(); ++i) {
                encProvider = new JweEncryption((KeyEncryptionProvider)keyProviders.get(i), ctProvider);
                theEncProviders.add((JweEncryptionProvider)encProvider);
            }
        }
        if (keyAlgos.size() == 1) {
            sharedProtectedHeaders.setKeyEncryptionAlgorithm((KeyAlgorithm)keyAlgos.iterator().next());
            for (int i = 0; i < perRecipientUnprotectedHeaders.size(); ++i) {
                perRecipientUnprotectedHeaders.get(i).removeProperty("alg");
            }
        }
        return theEncProviders;
    }

    protected void writeJws(JwsJsonProducer p, OutputStream os) throws IOException {
        byte[] bytes = StringUtils.toBytesUTF8((String)p.getJwsJsonSignedDocument());
        IOUtils.copy((InputStream)new ByteArrayInputStream(bytes), (OutputStream)os);
    }
}

