/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.server.protocol.framed.FramePriority;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import java.util.Deque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;

public class WebSocketFramePriority
implements FramePriority<WebSocketChannel, StreamSourceFrameChannel, StreamSinkFrameChannel> {
    private final Queue<StreamSinkFrameChannel> strictOrderQueue = new ConcurrentLinkedDeque<StreamSinkFrameChannel>();
    private StreamSinkFrameChannel currentFragmentedSender;
    boolean closed = false;
    boolean immediateCloseFrame = false;

    @Override
    public boolean insertFrame(StreamSinkFrameChannel newFrame, List<StreamSinkFrameChannel> pendingFrames) {
        StreamSinkFrameChannel order;
        if (newFrame.getType() != WebSocketFrameType.PONG && newFrame.getType() != WebSocketFrameType.PING && (order = this.strictOrderQueue.peek()) != null) {
            if (order != newFrame && order.isOpen()) {
                if (newFrame.getType() != WebSocketFrameType.CLOSE) {
                    return false;
                }
                if (!newFrame.getWebSocketChannel().isCloseFrameReceived() && !this.immediateCloseFrame) {
                    return false;
                }
            }
            if (order == newFrame && newFrame.isFinalFragment()) {
                this.strictOrderQueue.poll();
            }
        }
        if (this.closed) {
            newFrame.markBroken();
            return true;
        }
        if (this.currentFragmentedSender == null) {
            if (!newFrame.isWritesShutdown()) {
                this.currentFragmentedSender = newFrame;
            }
            if (pendingFrames.isEmpty()) {
                pendingFrames.add(newFrame);
            } else if (newFrame.getType() == WebSocketFrameType.PING || newFrame.getType() == WebSocketFrameType.PONG) {
                boolean done = false;
                for (int index = 1; index < pendingFrames.size(); ++index) {
                    WebSocketFrameType type = pendingFrames.get(index).getType();
                    if (type == WebSocketFrameType.PING || type == WebSocketFrameType.PONG) continue;
                    pendingFrames.add(index, newFrame);
                    done = true;
                    break;
                }
                if (!done) {
                    pendingFrames.add(newFrame);
                }
            } else {
                pendingFrames.add(newFrame);
            }
        } else if (newFrame.getType() == WebSocketFrameType.PING || newFrame.getType() == WebSocketFrameType.PONG) {
            if (pendingFrames.isEmpty()) {
                pendingFrames.add(newFrame);
            } else {
                pendingFrames.add(1, newFrame);
            }
        } else {
            if (this.currentFragmentedSender != newFrame) {
                return false;
            }
            if (newFrame.isFinalFragment()) {
                this.currentFragmentedSender = null;
            }
            pendingFrames.add(newFrame);
        }
        if (newFrame.getType() == WebSocketFrameType.CLOSE) {
            this.closed = true;
        }
        return true;
    }

    @Override
    public void frameAdded(StreamSinkFrameChannel addedFrame, List<StreamSinkFrameChannel> pendingFrames, Deque<StreamSinkFrameChannel> holdFrames) {
        if (addedFrame.isFinalFragment()) {
            StreamSinkFrameChannel frame;
            while ((frame = this.strictOrderQueue.peek()) != null && holdFrames.contains(frame) && this.insertFrame(frame, pendingFrames)) {
                holdFrames.remove(frame);
            }
            while (!holdFrames.isEmpty()) {
                frame = holdFrames.peek();
                if (this.insertFrame(frame, pendingFrames)) {
                    holdFrames.poll();
                    continue;
                }
                return;
            }
        }
    }

    void addToOrderQueue(StreamSinkFrameChannel channel) {
        if (channel.getType() != WebSocketFrameType.PING && channel.getType() != WebSocketFrameType.PONG) {
            this.strictOrderQueue.add(channel);
        }
    }

    void immediateCloseFrame() {
        this.immediateCloseFrame = true;
    }
}

