/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.reader;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.reader.MessageUtil;

public class StreamMessageUtil
extends MessageUtil {
    public static boolean streamReadBoolean(ActiveMQBuffer buff) {
        byte type = buff.readByte();
        return switch (type) {
            case 2 -> buff.readBoolean();
            case 10 -> {
                String s = buff.readNullableString();
                yield Boolean.valueOf(s);
            }
            default -> throw new IllegalStateException("Invalid conversion, type byte was " + type);
        };
    }

    public static byte streamReadByte(ActiveMQBuffer buff) {
        int index = buff.readerIndex();
        try {
            byte type = buff.readByte();
            return switch (type) {
                case 3 -> buff.readByte();
                case 10 -> {
                    String s = buff.readNullableString();
                    yield Byte.parseByte(s);
                }
                default -> throw new IllegalStateException("Invalid conversion");
            };
        }
        catch (NumberFormatException e) {
            buff.readerIndex(index);
            throw e;
        }
    }

    public static short streamReadShort(ActiveMQBuffer buff) {
        byte type = buff.readByte();
        return switch (type) {
            case 3 -> buff.readByte();
            case 5 -> buff.readShort();
            case 10 -> {
                String s = buff.readNullableString();
                yield Short.parseShort(s);
            }
            default -> throw new IllegalStateException("Invalid conversion");
        };
    }

    public static char streamReadChar(ActiveMQBuffer buff) {
        byte type = buff.readByte();
        switch (type) {
            case 11: {
                return (char)buff.readShort();
            }
            case 10: {
                String str = buff.readNullableString();
                if (str == null) {
                    throw new NullPointerException("Invalid conversion");
                }
                throw new IllegalStateException("Invalid conversion");
            }
        }
        throw new IllegalStateException("Invalid conversion");
    }

    public static int streamReadInteger(ActiveMQBuffer buff) {
        byte type = buff.readByte();
        return switch (type) {
            case 3 -> buff.readByte();
            case 5 -> buff.readShort();
            case 6 -> (short)buff.readInt();
            case 10 -> {
                String s = buff.readNullableString();
                yield (short)Integer.parseInt(s);
            }
            default -> throw new IllegalStateException("Invalid conversion");
        };
    }

    public static long streamReadLong(ActiveMQBuffer buff) {
        byte type = buff.readByte();
        return switch (type) {
            case 3 -> buff.readByte();
            case 5 -> buff.readShort();
            case 6 -> buff.readInt();
            case 7 -> buff.readLong();
            case 10 -> {
                String s = buff.readNullableString();
                yield Long.parseLong(s);
            }
            default -> throw new IllegalStateException("Invalid conversion");
        };
    }

    public static float streamReadFloat(ActiveMQBuffer buff) {
        byte type = buff.readByte();
        return switch (type) {
            case 8 -> Float.intBitsToFloat(buff.readInt());
            case 10 -> {
                String s = buff.readNullableString();
                yield Float.parseFloat(s);
            }
            default -> throw new IllegalStateException("Invalid conversion");
        };
    }

    public static double streamReadDouble(ActiveMQBuffer buff) {
        byte type = buff.readByte();
        return switch (type) {
            case 8 -> Float.intBitsToFloat(buff.readInt());
            case 9 -> Double.longBitsToDouble(buff.readLong());
            case 10 -> {
                String s = buff.readNullableString();
                yield Double.parseDouble(s);
            }
            default -> throw new IllegalStateException("Invalid conversion: " + type);
        };
    }

    public static String streamReadString(ActiveMQBuffer buff) {
        byte type = buff.readByte();
        return switch (type) {
            case 2 -> String.valueOf(buff.readBoolean());
            case 3 -> String.valueOf(buff.readByte());
            case 5 -> String.valueOf(buff.readShort());
            case 11 -> String.valueOf((char)buff.readShort());
            case 6 -> String.valueOf(buff.readInt());
            case 7 -> String.valueOf(buff.readLong());
            case 8 -> String.valueOf(Float.intBitsToFloat(buff.readInt()));
            case 9 -> String.valueOf(Double.longBitsToDouble(buff.readLong()));
            case 10 -> buff.readNullableString();
            default -> throw new IllegalStateException("Invalid conversion");
        };
    }

    public static Pair<Integer, Integer> streamReadBytes(ActiveMQBuffer buff, int remainingBytes, byte[] value) {
        if (remainingBytes == -1) {
            return new Pair((Object)0, (Object)-1);
        }
        if (remainingBytes == 0) {
            byte type = buff.readByte();
            if (type != 4) {
                throw new IllegalStateException("Invalid conversion");
            }
            remainingBytes = buff.readInt();
        }
        int read = Math.min(value.length, remainingBytes);
        buff.readBytes(value, 0, read);
        if ((remainingBytes -= read) == 0) {
            remainingBytes = -1;
        }
        return new Pair((Object)remainingBytes, (Object)read);
    }

    public static Object streamReadObject(ActiveMQBuffer buff) {
        byte type = buff.readByte();
        switch (type) {
            case 2: {
                return buff.readBoolean();
            }
            case 3: {
                return buff.readByte();
            }
            case 5: {
                return buff.readShort();
            }
            case 11: {
                return Character.valueOf((char)buff.readShort());
            }
            case 6: {
                return buff.readInt();
            }
            case 7: {
                return buff.readLong();
            }
            case 8: {
                return Float.valueOf(Float.intBitsToFloat(buff.readInt()));
            }
            case 9: {
                return Double.longBitsToDouble(buff.readLong());
            }
            case 10: {
                return buff.readNullableString();
            }
            case 4: {
                int bufferLen = buff.readInt();
                byte[] bytes = new byte[bufferLen];
                buff.readBytes(bytes);
                return bytes;
            }
        }
        throw new IllegalStateException("Invalid conversion");
    }
}

