/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.httpclient;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.httpclient.ContextHandlingHttpClient;
import net.shibboleth.utilities.java.support.httpclient.HttpClientContextHandler;
import net.shibboleth.utilities.java.support.httpclient.HttpClientSupport;
import net.shibboleth.utilities.java.support.httpclient.RequestConnectionClose;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.util.CharsetUtils;

public class HttpClientBuilder {
    private InetAddress socketLocalAddress;
    @Nonnull
    private Duration socketTimeout;
    private int socketBufferSize;
    @Nonnull
    private Duration connectionTimeout;
    @Nonnull
    private Duration connectionRequestTimeout;
    private int maxConnectionsTotal;
    private int maxConnectionsPerRoute;
    private boolean connectionDisregardTLSCertificate;
    @Nullable
    private LayeredConnectionSocketFactory tlsSocketFactory;
    private boolean connectionCloseAfterResponse;
    private boolean connectionStaleCheck;
    @Nullable
    private String connectionProxyHost;
    @Nullable
    private String userAgent;
    private int connectionProxyPort;
    @Nullable
    private String connectionProxyUsername;
    @Nullable
    private String connectionProxyPassword;
    private boolean httpFollowRedirects;
    @Nullable
    private String httpContentCharSet;
    @Nullable
    private HttpRequestRetryHandler retryHandler;
    @Nullable
    private ServiceUnavailableRetryStrategy serviceUnavailStrategy;
    private boolean disableAuthCaching;
    private boolean disableAutomaticRetries;
    private boolean disableConnectionState;
    private boolean disableContentCompression;
    private boolean disableCookieManagement;
    private boolean disableRedirectHandling;
    private boolean useSystemProperties;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    private List<HttpRequestInterceptor> requestInterceptorsFirst;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    private List<HttpRequestInterceptor> requestInterceptorsLast;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    private List<HttpResponseInterceptor> responseInterceptorsFirst;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    private List<HttpResponseInterceptor> responseInterceptorsLast;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    private List<HttpClientContextHandler> staticContextHandlers;
    private org.apache.http.impl.client.HttpClientBuilder apacheBuilder;

    public HttpClientBuilder() {
        this(org.apache.http.impl.client.HttpClientBuilder.create());
    }

    public HttpClientBuilder(@Nonnull org.apache.http.impl.client.HttpClientBuilder builder) {
        this.apacheBuilder = Constraint.isNotNull(builder, "Apache HttpClientBuilder may not be null");
        this.resetDefaults();
    }

    public void resetDefaults() {
        this.maxConnectionsTotal = -1;
        this.maxConnectionsPerRoute = -1;
        this.socketLocalAddress = null;
        this.socketBufferSize = 8192;
        this.socketTimeout = Duration.ofSeconds(60L);
        this.connectionTimeout = Duration.ofSeconds(60L);
        this.connectionRequestTimeout = Duration.ofSeconds(60L);
        this.connectionDisregardTLSCertificate = false;
        this.connectionCloseAfterResponse = true;
        this.connectionStaleCheck = false;
        this.connectionProxyHost = null;
        this.connectionProxyPort = 8080;
        this.connectionProxyUsername = null;
        this.connectionProxyPassword = null;
        this.httpFollowRedirects = true;
        this.httpContentCharSet = "UTF-8";
        this.userAgent = null;
        this.requestInterceptorsFirst = Collections.emptyList();
        this.requestInterceptorsLast = Collections.emptyList();
        this.responseInterceptorsFirst = Collections.emptyList();
        this.responseInterceptorsLast = Collections.emptyList();
        this.staticContextHandlers = Collections.emptyList();
    }

    public int getMaxConnectionsTotal() {
        return this.maxConnectionsTotal;
    }

    public void setMaxConnectionsTotal(int max) {
        this.maxConnectionsTotal = max;
    }

    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    public void setMaxConnectionsPerRoute(int max) {
        this.maxConnectionsPerRoute = max;
    }

    public InetAddress getSocketLocalAddress() {
        return this.socketLocalAddress;
    }

    public void setSocketLocalAddress(InetAddress address) {
        this.socketLocalAddress = address;
    }

    public void setSocketLocalAddress(String ipOrHost) throws UnknownHostException {
        this.socketLocalAddress = InetAddress.getByName(Constraint.isNotNull(ipOrHost, "IP or hostname may not be null"));
    }

    @Nonnull
    public Duration getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(@Nonnull Duration timeout) {
        Constraint.isNotNull(timeout, "Timeout cannot be null");
        Constraint.isLessThanOrEqual(Integer.MAX_VALUE, timeout.toMillis(), "Timeout too large");
        this.socketTimeout = timeout;
    }

    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setSocketBufferSize(int size) {
        this.socketBufferSize = Constraint.isGreaterThan(0, size, "Socket buffer size must be greater than 0");
    }

    @Nonnull
    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(@Nonnull Duration timeout) {
        Constraint.isNotNull(timeout, "Connection timeout cannot be null");
        Constraint.isLessThanOrEqual(Integer.MAX_VALUE, timeout.toMillis(), "Connection timeout too large");
        this.connectionTimeout = timeout;
    }

    @Nonnull
    public Duration getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(@Nonnull Duration timeout) {
        Constraint.isNotNull(timeout, "Connection request timeout cannot be null");
        Constraint.isLessThanOrEqual(Integer.MAX_VALUE, timeout.toMillis(), "Connection request timeout too large");
        this.connectionRequestTimeout = timeout;
    }

    public boolean isConnectionDisregardTLSCertificate() {
        return this.connectionDisregardTLSCertificate;
    }

    public void setConnectionDisregardTLSCertificate(boolean disregard) {
        this.connectionDisregardTLSCertificate = disregard;
    }

    @Nullable
    public LayeredConnectionSocketFactory getTLSSocketFactory() {
        return this.tlsSocketFactory;
    }

    public void setTLSSocketFactory(@Nullable LayeredConnectionSocketFactory factory) {
        this.tlsSocketFactory = factory;
    }

    public boolean isConnectionCloseAfterResponse() {
        return this.connectionCloseAfterResponse;
    }

    public void setConnectionCloseAfterResponse(boolean close) {
        this.connectionCloseAfterResponse = close;
    }

    @Deprecated(forRemoval=true)
    public boolean isConnectionStalecheck() {
        return this.isConnectionStaleCheck();
    }

    @Deprecated(forRemoval=true)
    public void setConnectionStalecheck(boolean check) {
        this.setConnectionStaleCheck(check);
    }

    @Deprecated(forRemoval=true)
    public boolean isConnectionStaleCheck() {
        return this.connectionStaleCheck;
    }

    @Deprecated(forRemoval=true)
    public void setConnectionStaleCheck(boolean check) {
        this.connectionStaleCheck = check;
    }

    @Nullable
    public String getConnectionProxyHost() {
        return this.connectionProxyHost;
    }

    public void setConnectionProxyHost(@Nullable String host) {
        this.connectionProxyHost = StringSupport.trimOrNull(host);
    }

    public int getConnectionProxyPort() {
        return this.connectionProxyPort;
    }

    public void setConnectionProxyPort(int port) {
        this.connectionProxyPort = (int)Constraint.numberInRangeExclusive(0L, 65536L, port, "Proxy port must be between 0 and 65536, exclusive");
    }

    @Nullable
    public String getConnectionProxyUsername() {
        return this.connectionProxyUsername;
    }

    public void setConnectionProxyUsername(@Nullable String usename) {
        this.connectionProxyUsername = usename;
    }

    @Nullable
    public String getConnectionProxyPassword() {
        return this.connectionProxyPassword;
    }

    public void setConnectionProxyPassword(@Nullable String password) {
        this.connectionProxyPassword = password;
    }

    public boolean isHttpFollowRedirects() {
        return this.httpFollowRedirects;
    }

    public void setHttpFollowRedirects(boolean followRedirects) {
        this.httpFollowRedirects = followRedirects;
    }

    @Nullable
    public String getHttpContentCharSet() {
        return this.httpContentCharSet;
    }

    public void setHttpContentCharSet(@Nullable String charSet) {
        this.httpContentCharSet = charSet;
    }

    @Nullable
    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(@Nullable String what) {
        this.userAgent = what;
    }

    @Nullable
    public HttpRequestRetryHandler getHttpRequestRetryHandler() {
        return this.retryHandler;
    }

    public void setHttpRequestRetryHandler(@Nullable HttpRequestRetryHandler handler) {
        this.retryHandler = handler;
    }

    @Nullable
    public ServiceUnavailableRetryStrategy getServiceUnavailableRetryHandler() {
        return this.serviceUnavailStrategy;
    }

    public void setServiceUnavailableRetryHandler(@Nullable ServiceUnavailableRetryStrategy strategy) {
        this.serviceUnavailStrategy = strategy;
    }

    public boolean isDisableAuthCaching() {
        return this.disableAuthCaching;
    }

    public void setDisableAuthCaching(boolean flag) {
        this.disableAuthCaching = flag;
    }

    public boolean isDisableAutomaticRetries() {
        return this.disableAutomaticRetries;
    }

    public void setDisableAutomaticRetries(boolean flag) {
        this.disableAutomaticRetries = flag;
    }

    public boolean isDisableConnectionState() {
        return this.disableConnectionState;
    }

    public void setDisableConnectionState(boolean flag) {
        this.disableConnectionState = flag;
    }

    public boolean isDisableContentCompression() {
        return this.disableContentCompression;
    }

    public void setDisableContentCompression(boolean flag) {
        this.disableContentCompression = flag;
    }

    public boolean isDisableCookieManagement() {
        return this.disableCookieManagement;
    }

    public void setDisableCookieManagement(boolean flag) {
        this.disableCookieManagement = flag;
    }

    public boolean isDisableRedirectHandling() {
        return this.disableRedirectHandling;
    }

    public void setDisableRedirectHandling(boolean flag) {
        this.disableRedirectHandling = flag;
    }

    public boolean isUseSystemProperties() {
        return this.useSystemProperties;
    }

    public void setUseSystemProperties(boolean flag) {
        this.useSystemProperties = flag;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<HttpRequestInterceptor> getFirstRequestInterceptors() {
        return this.requestInterceptorsFirst;
    }

    public void setFirstRequestInterceptors(@Nullable @NonnullElements List<HttpRequestInterceptor> interceptors) {
        this.requestInterceptorsFirst = interceptors != null ? List.copyOf(interceptors) : Collections.emptyList();
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<HttpRequestInterceptor> getLastRequestInterceptors() {
        return this.requestInterceptorsLast;
    }

    public void setLastRequestInterceptors(@Nullable @NonnullElements List<HttpRequestInterceptor> interceptors) {
        this.requestInterceptorsLast = interceptors != null ? List.copyOf(interceptors) : Collections.emptyList();
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<HttpResponseInterceptor> getFirstResponseInterceptors() {
        return this.responseInterceptorsFirst;
    }

    public void setFirstResponseInterceptors(@Nullable @NonnullElements List<HttpResponseInterceptor> interceptors) {
        this.responseInterceptorsFirst = interceptors != null ? List.copyOf(interceptors) : Collections.emptyList();
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<HttpResponseInterceptor> getLastResponseInterceptors() {
        return this.responseInterceptorsLast;
    }

    public void setLastResponseInterceptors(@Nullable @NonnullElements List<HttpResponseInterceptor> interceptors) {
        this.responseInterceptorsLast = interceptors != null ? List.copyOf(interceptors) : Collections.emptyList();
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<HttpClientContextHandler> getStaticContextHandlers() {
        return this.staticContextHandlers;
    }

    public void setStaticContextHandlers(@Nullable @NonnullElements List<HttpClientContextHandler> handlers) {
        this.staticContextHandlers = handlers != null ? List.copyOf(handlers) : Collections.emptyList();
    }

    public HttpClient buildClient() throws Exception {
        this.decorateApacheBuilder();
        return new ContextHandlingHttpClient(this.getApacheBuilder().build(), this.getStaticContextHandlers());
    }

    protected void decorateApacheBuilder() throws Exception {
        org.apache.http.impl.client.HttpClientBuilder builder = this.getApacheBuilder();
        if (this.getTLSSocketFactory() != null) {
            builder.setSSLSocketFactory(this.getTLSSocketFactory());
        } else if (this.connectionDisregardTLSCertificate) {
            builder.setSSLSocketFactory(HttpClientSupport.buildNoTrustTLSSocketFactory());
        } else {
            builder.setSSLSocketFactory(HttpClientSupport.buildStrictTLSSocketFactory());
        }
        if (this.connectionCloseAfterResponse) {
            if (!this.getFirstRequestInterceptors().stream().anyMatch(RequestConnectionClose.class::isInstance)) {
                if (!this.getLastRequestInterceptors().stream().anyMatch(RequestConnectionClose.class::isInstance)) {
                    builder.addInterceptorLast((HttpRequestInterceptor)new RequestConnectionClose());
                }
            }
        }
        if (this.maxConnectionsTotal > 0) {
            builder.setMaxConnTotal(this.maxConnectionsTotal);
        }
        if (this.maxConnectionsPerRoute > 0) {
            builder.setMaxConnPerRoute(this.maxConnectionsPerRoute);
        }
        if (this.retryHandler != null) {
            builder.setRetryHandler(this.retryHandler);
        }
        if (this.serviceUnavailStrategy != null) {
            builder.setServiceUnavailableRetryStrategy(this.serviceUnavailStrategy);
        }
        if (this.isDisableAuthCaching()) {
            builder.disableAuthCaching();
        }
        if (this.isDisableAutomaticRetries()) {
            builder.disableAutomaticRetries();
        }
        if (this.isDisableConnectionState()) {
            builder.disableConnectionState();
        }
        if (this.isDisableContentCompression()) {
            builder.disableContentCompression();
        }
        if (this.isDisableCookieManagement()) {
            builder.disableCookieManagement();
        }
        if (this.isDisableRedirectHandling()) {
            builder.disableRedirectHandling();
        }
        if (this.isUseSystemProperties()) {
            builder.useSystemProperties();
        }
        this.getFirstRequestInterceptors().forEach(arg_0 -> ((org.apache.http.impl.client.HttpClientBuilder)builder).addInterceptorFirst(arg_0));
        this.getLastRequestInterceptors().forEach(arg_0 -> ((org.apache.http.impl.client.HttpClientBuilder)builder).addInterceptorLast(arg_0));
        this.getFirstResponseInterceptors().forEach(arg_0 -> ((org.apache.http.impl.client.HttpClientBuilder)builder).addInterceptorFirst(arg_0));
        this.getLastResponseInterceptors().forEach(arg_0 -> ((org.apache.http.impl.client.HttpClientBuilder)builder).addInterceptorLast(arg_0));
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (this.socketLocalAddress != null) {
            requestConfigBuilder.setLocalAddress(this.socketLocalAddress);
        }
        if (!this.socketTimeout.isNegative()) {
            requestConfigBuilder.setSocketTimeout((int)this.socketTimeout.toMillis());
        }
        if (!this.connectionTimeout.isNegative()) {
            requestConfigBuilder.setConnectTimeout((int)this.connectionTimeout.toMillis());
        }
        if (!this.connectionRequestTimeout.isNegative()) {
            requestConfigBuilder.setConnectionRequestTimeout((int)this.connectionRequestTimeout.toMillis());
        }
        requestConfigBuilder.setStaleConnectionCheckEnabled(this.connectionStaleCheck);
        requestConfigBuilder.setRedirectsEnabled(this.httpFollowRedirects);
        if (this.connectionProxyHost != null) {
            HttpHost proxyHost = new HttpHost(this.connectionProxyHost, this.connectionProxyPort);
            requestConfigBuilder.setProxy(proxyHost);
            if (this.connectionProxyUsername != null && this.connectionProxyPassword != null) {
                BasicCredentialsProvider credProvider = new BasicCredentialsProvider();
                credProvider.setCredentials(new AuthScope(this.connectionProxyHost, this.connectionProxyPort), (Credentials)new UsernamePasswordCredentials(this.connectionProxyUsername, this.connectionProxyPassword));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credProvider);
            }
        }
        ConnectionConfig.Builder connectionConfigBuilder = ConnectionConfig.custom();
        connectionConfigBuilder.setBufferSize(this.socketBufferSize);
        if (this.httpContentCharSet != null) {
            connectionConfigBuilder.setCharset(CharsetUtils.get((String)this.httpContentCharSet));
        }
        builder.setDefaultRequestConfig(requestConfigBuilder.build());
        builder.setDefaultConnectionConfig(connectionConfigBuilder.build());
        if (null != this.userAgent) {
            builder.setUserAgent(this.userAgent);
        }
    }

    protected org.apache.http.impl.client.HttpClientBuilder getApacheBuilder() {
        return this.apacheBuilder;
    }
}

