/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.statistics;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.ehcache.shadow.org.terracotta.statistics.AbstractOperationStatistic;
import org.ehcache.shadow.org.terracotta.statistics.OperationStatistic;

class GeneralOperationStatistic<T extends Enum<T>>
extends AbstractOperationStatistic<T>
implements OperationStatistic<T> {
    private final LongAdder[] counts;

    GeneralOperationStatistic(String name, Set<String> tags, Map<String, ? extends Object> properties, Class<T> type) {
        super(name, tags, properties, type);
        this.counts = new LongAdder[((Enum[])type.getEnumConstants()).length];
        for (int i = 0; i < this.counts.length; ++i) {
            this.counts[i] = new LongAdder();
        }
    }

    @Override
    public long count(T type) {
        return this.counts[((Enum)type).ordinal()].sum();
    }

    @Override
    public long sum(Set<T> types) {
        long sum = 0L;
        for (Enum t : types) {
            sum += this.counts[t.ordinal()].sum();
        }
        return sum;
    }

    @Override
    public void end(T result) {
        this.counts[((Enum)result).ordinal()].increment();
        super.end(result);
    }

    public String toString() {
        Enum[] constants = (Enum[])this.type.getEnumConstants();
        return IntStream.range(0, constants.length).mapToObj(i -> constants[i] + "=" + this.counts[i]).collect(Collectors.joining(", ", "[", "]"));
    }
}

