/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import net.sf.saxon.regex.Operation;
import net.sf.saxon.regex.REFlags;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.REProgram;
import net.sf.saxon.z.IntIterator;

public class OpTrace
extends Operation {
    private Operation base;
    private static int counter = 0;

    OpTrace(Operation base) {
        this.base = base;
    }

    @Override
    public IntIterator iterateMatches(REMatcher matcher, int position) {
        final IntIterator baseIter = this.base.iterateMatches(matcher, position);
        final int iterNr = counter++;
        String clName = baseIter.getClass().getName();
        int lastDot = clName.lastIndexOf(".");
        String iterName = clName.substring(lastDot + 1);
        System.err.println("Iterating over " + this.base.getClass().getSimpleName() + " " + this.base.display() + " at position " + position + " returning " + iterName + " " + iterNr);
        return new IntIterator(){

            @Override
            public boolean hasNext() {
                boolean b = baseIter.hasNext();
                System.err.println("IntIterator " + iterNr + " hasNext() = " + b);
                return b;
            }

            @Override
            public int next() {
                int n = baseIter.next();
                System.err.println("IntIterator " + iterNr + " next() = " + n);
                return n;
            }
        };
    }

    @Override
    public int getMatchLength() {
        return this.base.getMatchLength();
    }

    @Override
    public int matchesEmptyString() {
        return this.base.matchesEmptyString();
    }

    @Override
    public int getMaxLoopingDepth() {
        return this.base.getMaxLoopingDepth();
    }

    @Override
    public Operation optimize(REProgram program, REFlags flags) {
        this.base = this.base.optimize(program, flags);
        return this;
    }

    @Override
    public String display() {
        return this.base.display();
    }
}

