/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.Arrays;
import org.apache.datasketches.hive.tuple.ObjectInspectorValidator;
import org.apache.datasketches.hive.tuple.State;
import org.apache.datasketches.hive.tuple.UnionSketchUDAF;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryDeserializer;
import org.apache.datasketches.tuple.adouble.DoubleSummarySetOperations;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="UnionSketch", value="_FUNC_(sketch, nominal number of entries, summary mode)", extended="Returns a Sketch<DoubleSummary> as a binary blob that can be operated on by other tuple sketch related functions. The nominal number of entries is optional, must be a power of 2, does not have to match the input sketches, and controls the relative error expected from the sketch. A number of 16384 can be expected to yield errors of roughly +-1.5% in the estimation of uniques. The default number is defined in the sketches-core library and at the time of this writing was 4096 (about 3% error). Summary mode must be one of: 'Sum', 'Min', 'Max'")
public class UnionDoubleSummaryWithModeSketchUDAF
extends UnionSketchUDAF {
    @Override
    public GenericUDAFEvaluator createEvaluator() {
        return new UnionDoubleSummaryWithModeSketchEvaluator();
    }

    @Override
    protected void checkExtraArguments(ObjectInspector[] inspectors) throws SemanticException {
        if (inspectors.length > 3) {
            throw new UDFArgumentException("Expected no more than 3 arguments");
        }
        if (inspectors.length > 2) {
            ObjectInspectorValidator.validateGivenPrimitiveCategory(inspectors[2], 2, PrimitiveObjectInspector.PrimitiveCategory.STRING);
        }
    }

    public static class UnionDoubleSummaryWithModeSketchEvaluator
    extends UnionSketchUDAF.UnionSketchEvaluator<DoubleSummary> {
        private static final SummaryDeserializer<DoubleSummary> SUMMARY_DESERIALIZER = new DoubleSummaryDeserializer();
        private static final String SUMMARY_MODE_FIELD = "summaryMode";
        private PrimitiveObjectInspector summaryModeInspector_;
        private DoubleSummary.Mode summaryMode_ = DoubleSummary.Mode.Sum;

        @Override
        protected SummaryDeserializer<DoubleSummary> getSummaryDeserializer() {
            return SUMMARY_DESERIALIZER;
        }

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] inspectors) throws HiveException {
            ObjectInspector resultInspector = super.init(mode, inspectors);
            if ((mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) && inspectors.length > 2) {
                this.summaryModeInspector_ = (PrimitiveObjectInspector)inspectors[2];
            }
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                return ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("nominalEntries", SUMMARY_MODE_FIELD, "sketch"), Arrays.asList(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.STRING), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY)));
            }
            return resultInspector;
        }

        @Override
        protected SummaryFactory<DoubleSummary> getSummaryFactory(Object[] data) {
            return null;
        }

        @Override
        protected SummarySetOperations<DoubleSummary> getSummarySetOperationsForIterate(Object[] data) {
            if (this.summaryModeInspector_ != null) {
                this.summaryMode_ = DoubleSummary.Mode.valueOf((String)PrimitiveObjectInspectorUtils.getString((Object)data[2], (PrimitiveObjectInspector)this.summaryModeInspector_));
            }
            return new DoubleSummarySetOperations(this.summaryMode_);
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
            State state = (State)buf;
            Sketch intermediate = state.getResult();
            if (intermediate == null) {
                return null;
            }
            byte[] bytes = intermediate.toByteArray();
            return Arrays.asList(new IntWritable(state.getNominalNumEntries()), new Text(this.summaryMode_.toString()), new BytesWritable(bytes));
        }

        @Override
        protected SummarySetOperations<DoubleSummary> getSummarySetOperationsForMerge(Object data) {
            this.summaryMode_ = DoubleSummary.Mode.valueOf((String)((Text)this.intermediateInspector_.getStructFieldData(data, this.intermediateInspector_.getStructFieldRef(SUMMARY_MODE_FIELD))).toString());
            return new DoubleSummarySetOperations(this.summaryMode_);
        }
    }
}

