/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DruidIssue11544Test {
    private static final MemoryRequestServer myMemReqSvr = Resource.defaultMemReqSvr;

    @Test
    public void withByteBuffer() {
        int size1 = 8000;
        ByteBuffer bb = ByteBuffer.allocateDirect(size1);
        bb.order(ByteOrder.nativeOrder());
        WritableMemory mem1 = WritableMemory.writableWrap((ByteBuffer)bb);
        Assert.assertTrue((boolean)mem1.isDirect());
        int size2 = size1 * 2;
        WritableMemory mem2 = myMemReqSvr.request(mem1, (long)size2);
        Assert.assertFalse((boolean)mem2.isDirect());
        Assert.assertEquals((long)mem2.getCapacity(), (long)size2);
        mem1.copyTo(0L, mem2, 0L, (long)size1);
        myMemReqSvr.requestClose(mem1, mem2);
        Assert.assertTrue((boolean)mem1.isAlive());
        Assert.assertTrue((boolean)mem2.isAlive());
        int size3 = size2 * 2;
        WritableMemory mem3 = myMemReqSvr.request(mem2, (long)size3);
        Assert.assertFalse((boolean)mem3.isDirect());
        Assert.assertEquals((long)mem3.getCapacity(), (long)size3);
        mem2.copyTo(0L, mem3, 0L, (long)size2);
        myMemReqSvr.requestClose(mem2, mem3);
        Assert.assertTrue((boolean)mem2.isAlive());
        Assert.assertTrue((boolean)mem3.isAlive());
    }
}

