/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import jdk.incubator.foreign.MemoryAccess;
import jdk.incubator.foreign.MemorySegment;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.internal.WritableBufferImpl;

final class NonNativeWritableBufferImpl
extends WritableBufferImpl {
    NonNativeWritableBufferImpl(MemorySegment seg, int typeId, MemoryRequestServer memReqSvr) {
        super(seg, typeId, memReqSvr);
    }

    @Override
    public char getChar() {
        long pos = this.getPosition();
        this.setPosition(pos + 2L);
        return MemoryAccess.getCharAtOffset((MemorySegment)this.seg, (long)pos, (ByteOrder)NON_NATIVE_BYTE_ORDER);
    }

    @Override
    public char getChar(long offsetBytes) {
        return MemoryAccess.getCharAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER);
    }

    @Override
    public void getCharArray(char[] dstArray, int dstOffsetChars, int lengthChars) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthChars << 1;
        MemorySegment srcSlice = this.seg.asSlice(pos, copyBytes);
        MemorySegment dstSlice = MemorySegment.ofArray((char[])dstArray).asSlice((long)(dstOffsetChars << 1), copyBytes);
        for (int index = 0; index < lengthChars; ++index) {
            char aChar = MemoryAccess.getCharAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER);
            MemoryAccess.setCharAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER, (char)aChar);
        }
        this.setPosition(pos + copyBytes);
    }

    @Override
    public double getDouble() {
        long pos = this.getPosition();
        this.setPosition(pos + 8L);
        return MemoryAccess.getDoubleAtOffset((MemorySegment)this.seg, (long)pos, (ByteOrder)NON_NATIVE_BYTE_ORDER);
    }

    @Override
    public double getDouble(long offsetBytes) {
        return MemoryAccess.getDoubleAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER);
    }

    @Override
    public void getDoubleArray(double[] dstArray, int dstOffsetDoubles, int lengthDoubles) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthDoubles << 3;
        MemorySegment srcSlice = this.seg.asSlice(pos, copyBytes);
        MemorySegment dstSlice = MemorySegment.ofArray((double[])dstArray).asSlice((long)(dstOffsetDoubles << 3), copyBytes);
        for (int index = 0; index < lengthDoubles; ++index) {
            double dbl = MemoryAccess.getDoubleAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER);
            MemoryAccess.setDoubleAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER, (double)dbl);
        }
        this.setPosition(pos + copyBytes);
    }

    @Override
    public float getFloat() {
        long pos = this.getPosition();
        this.setPosition(pos + 4L);
        return MemoryAccess.getFloatAtOffset((MemorySegment)this.seg, (long)pos, (ByteOrder)NON_NATIVE_BYTE_ORDER);
    }

    @Override
    public float getFloat(long offsetBytes) {
        return MemoryAccess.getFloatAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER);
    }

    @Override
    public void getFloatArray(float[] dstArray, int dstOffsetFloats, int lengthFloats) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthFloats << 2;
        MemorySegment srcSlice = this.seg.asSlice(pos, copyBytes);
        MemorySegment dstSlice = MemorySegment.ofArray((float[])dstArray).asSlice((long)(dstOffsetFloats << 2), copyBytes);
        for (int index = 0; index < lengthFloats; ++index) {
            float flt = MemoryAccess.getFloatAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER);
            MemoryAccess.setFloatAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER, (float)flt);
        }
        this.setPosition(pos + copyBytes);
    }

    @Override
    public int getInt() {
        long pos = this.getPosition();
        this.setPosition(pos + 4L);
        return MemoryAccess.getIntAtOffset((MemorySegment)this.seg, (long)pos, (ByteOrder)NON_NATIVE_BYTE_ORDER);
    }

    @Override
    public int getInt(long offsetBytes) {
        return MemoryAccess.getIntAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER);
    }

    @Override
    public void getIntArray(int[] dstArray, int dstOffsetInts, int lengthInts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthInts << 2;
        MemorySegment srcSlice = this.seg.asSlice(pos, copyBytes);
        MemorySegment dstSlice = MemorySegment.ofArray((int[])dstArray).asSlice((long)(dstOffsetInts << 2), copyBytes);
        for (int index = 0; index < lengthInts; ++index) {
            int anInt = MemoryAccess.getIntAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER);
            MemoryAccess.setIntAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER, (int)anInt);
        }
        this.setPosition(pos + copyBytes);
    }

    @Override
    public long getLong() {
        long pos = this.getPosition();
        this.setPosition(pos + 8L);
        return MemoryAccess.getLongAtOffset((MemorySegment)this.seg, (long)pos, (ByteOrder)NON_NATIVE_BYTE_ORDER);
    }

    @Override
    public long getLong(long offsetBytes) {
        return MemoryAccess.getLongAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER);
    }

    @Override
    public void getLongArray(long[] dstArray, int dstOffsetLongs, int lengthLongs) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthLongs << 3;
        MemorySegment srcSlice = this.seg.asSlice(pos, copyBytes);
        MemorySegment dstSlice = MemorySegment.ofArray((long[])dstArray).asSlice((long)(dstOffsetLongs << 3), copyBytes);
        for (int index = 0; index < lengthLongs; ++index) {
            long aLong = MemoryAccess.getLongAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER);
            MemoryAccess.setLongAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER, (long)aLong);
        }
        this.setPosition(pos + copyBytes);
    }

    @Override
    public short getShort() {
        long pos = this.getPosition();
        this.setPosition(pos + 2L);
        return MemoryAccess.getShortAtOffset((MemorySegment)this.seg, (long)pos, (ByteOrder)NON_NATIVE_BYTE_ORDER);
    }

    @Override
    public short getShort(long offsetBytes) {
        return MemoryAccess.getShortAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER);
    }

    @Override
    public void getShortArray(short[] dstArray, int dstOffsetShorts, int lengthShorts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthShorts << 1;
        MemorySegment srcSlice = this.seg.asSlice(pos, copyBytes);
        MemorySegment dstSlice = MemorySegment.ofArray((short[])dstArray).asSlice((long)(dstOffsetShorts << 1), copyBytes);
        for (int index = 0; index < lengthShorts; ++index) {
            short aShort = MemoryAccess.getShortAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER);
            MemoryAccess.setShortAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER, (short)aShort);
        }
        this.setPosition(pos + copyBytes);
    }

    @Override
    public void putChar(char value) {
        long pos = this.getPosition();
        MemoryAccess.setCharAtOffset((MemorySegment)this.seg, (long)pos, (ByteOrder)NON_NATIVE_BYTE_ORDER, (char)value);
        this.setPosition(pos + 2L);
    }

    @Override
    public void putChar(long offsetBytes, char value) {
        MemoryAccess.setCharAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER, (char)value);
    }

    @Override
    public void putCharArray(char[] srcArray, int srcOffsetChars, int lengthChars) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthChars << 1;
        MemorySegment srcSlice = MemorySegment.ofArray((char[])srcArray).asSlice((long)(srcOffsetChars << 1), copyBytes);
        MemorySegment dstSlice = this.seg.asSlice(pos, copyBytes);
        for (int index = 0; index < lengthChars; ++index) {
            char aChar = MemoryAccess.getCharAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER);
            MemoryAccess.setCharAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER, (char)aChar);
        }
        this.setPosition(pos + copyBytes);
    }

    @Override
    public void putDouble(double value) {
        long pos = this.getPosition();
        MemoryAccess.setDoubleAtOffset((MemorySegment)this.seg, (long)pos, (ByteOrder)NON_NATIVE_BYTE_ORDER, (double)value);
        this.setPosition(pos + 8L);
    }

    @Override
    public void putDouble(long offsetBytes, double value) {
        MemoryAccess.setDoubleAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER, (double)value);
    }

    @Override
    public void putDoubleArray(double[] srcArray, int srcOffsetDoubles, int lengthDoubles) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthDoubles << 3;
        MemorySegment srcSlice = MemorySegment.ofArray((double[])srcArray).asSlice((long)(srcOffsetDoubles << 3), copyBytes);
        MemorySegment dstSlice = this.seg.asSlice(pos, copyBytes);
        for (int index = 0; index < lengthDoubles; ++index) {
            double dbl = MemoryAccess.getDoubleAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER);
            MemoryAccess.setDoubleAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER, (double)dbl);
        }
        this.setPosition(pos + copyBytes);
    }

    @Override
    public void putFloat(float value) {
        long pos = this.getPosition();
        MemoryAccess.setFloatAtOffset((MemorySegment)this.seg, (long)pos, (ByteOrder)NON_NATIVE_BYTE_ORDER, (float)value);
        this.setPosition(pos + 4L);
    }

    @Override
    public void putFloat(long offsetBytes, float value) {
        MemoryAccess.setFloatAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER, (float)value);
    }

    @Override
    public void putFloatArray(float[] srcArray, int srcOffsetFloats, int lengthFloats) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthFloats << 2;
        MemorySegment srcSlice = MemorySegment.ofArray((float[])srcArray).asSlice((long)(srcOffsetFloats << 2), copyBytes);
        MemorySegment dstSlice = this.seg.asSlice(pos, copyBytes);
        for (int index = 0; index < lengthFloats; ++index) {
            float flt = MemoryAccess.getFloatAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER);
            MemoryAccess.setFloatAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER, (float)flt);
        }
        this.setPosition(pos + copyBytes);
    }

    @Override
    public void putInt(int value) {
        long pos = this.getPosition();
        MemoryAccess.setIntAtOffset((MemorySegment)this.seg, (long)pos, (ByteOrder)NON_NATIVE_BYTE_ORDER, (int)value);
        this.setPosition(pos + 4L);
    }

    @Override
    public void putInt(long offsetBytes, int value) {
        MemoryAccess.setIntAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER, (int)value);
    }

    @Override
    public void putIntArray(int[] srcArray, int srcOffsetInts, int lengthInts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthInts << 2;
        MemorySegment srcSlice = MemorySegment.ofArray((int[])srcArray).asSlice((long)(srcOffsetInts << 2), copyBytes);
        MemorySegment dstSlice = this.seg.asSlice(pos, copyBytes);
        for (int index = 0; index < lengthInts; ++index) {
            int anInt = MemoryAccess.getIntAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER);
            MemoryAccess.setIntAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER, (int)anInt);
        }
        this.setPosition(pos + copyBytes);
    }

    @Override
    public void putLong(long value) {
        long pos = this.getPosition();
        MemoryAccess.setLongAtOffset((MemorySegment)this.seg, (long)pos, (ByteOrder)NON_NATIVE_BYTE_ORDER, (long)value);
        this.setPosition(pos + 8L);
    }

    @Override
    public void putLong(long offsetBytes, long value) {
        MemoryAccess.setLongAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER, (long)value);
    }

    @Override
    public void putLongArray(long[] srcArray, int srcOffsetLongs, int lengthLongs) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthLongs << 3;
        MemorySegment srcSlice = MemorySegment.ofArray((long[])srcArray).asSlice((long)(srcOffsetLongs << 3), copyBytes);
        MemorySegment dstSlice = this.seg.asSlice(pos, copyBytes);
        for (int index = 0; index < lengthLongs; ++index) {
            long aLong = MemoryAccess.getLongAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER);
            MemoryAccess.setLongAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER, (long)aLong);
        }
        this.setPosition(pos + copyBytes);
    }

    @Override
    public void putShort(short value) {
        long pos = this.getPosition();
        MemoryAccess.setShortAtOffset((MemorySegment)this.seg, (long)pos, (ByteOrder)NON_NATIVE_BYTE_ORDER, (short)value);
        this.setPosition(pos + 2L);
    }

    @Override
    public void putShort(long offsetBytes, short value) {
        MemoryAccess.setShortAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER, (short)value);
    }

    @Override
    public void putShortArray(short[] srcArray, int srcOffsetShorts, int lengthShorts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthShorts << 1;
        MemorySegment srcSlice = MemorySegment.ofArray((short[])srcArray).asSlice((long)(srcOffsetShorts << 1), copyBytes);
        MemorySegment dstSlice = this.seg.asSlice(pos, copyBytes);
        for (int index = 0; index < lengthShorts; ++index) {
            short aShort = MemoryAccess.getShortAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER);
            MemoryAccess.setShortAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER, (short)aShort);
        }
        this.setPosition(pos + copyBytes);
    }
}

