/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.frequencies;

import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.frequencies.DataToFrequentStringsSketch;
import org.apache.datasketches.pig.tuple.PigUtil;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataToFrequentStringsSketchTest {
    @Test
    public void execNullInputTuple() throws Exception {
        DataToFrequentStringsSketch func = new DataToFrequentStringsSketch("8");
        Tuple resultTuple = (Tuple)func.exec(null);
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void execEmptyInputTuple() throws Exception {
        DataToFrequentStringsSketch func = new DataToFrequentStringsSketch("8");
        Tuple resultTuple = (Tuple)func.exec(TupleFactory.getInstance().newTuple());
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void execEmptyBag() throws Exception {
        DataToFrequentStringsSketch func = new DataToFrequentStringsSketch("8");
        Tuple inputTuple = PigUtil.objectsToTuple(BagFactory.getInstance().newDefaultBag());
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ItemsSketch sketch = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes.get()), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertEquals((int)sketch.getNumActiveItems(), (int)0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void execWrongSizeOfInnerTuple() throws Exception {
        DataToFrequentStringsSketch func = new DataToFrequentStringsSketch("8");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple(new Object[0]));
        Tuple inputTuple = PigUtil.objectsToTuple(bag);
        func.exec(inputTuple);
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void execWrongItemType() throws Exception {
        DataToFrequentStringsSketch func = new DataToFrequentStringsSketch("8");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple(new Object(), 1L));
        Tuple inputTuple = PigUtil.objectsToTuple(bag);
        func.exec(inputTuple);
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void execWrongCountType() throws Exception {
        DataToFrequentStringsSketch func = new DataToFrequentStringsSketch("8");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple("a", 1));
        Tuple inputTuple = PigUtil.objectsToTuple(bag);
        func.exec(inputTuple);
    }

    @Test
    public void exec() throws Exception {
        DataToFrequentStringsSketch func = new DataToFrequentStringsSketch("8");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple("a"));
        bag.add(PigUtil.objectsToTuple("b", 5L));
        bag.add(PigUtil.objectsToTuple("a", 2L));
        bag.add(PigUtil.objectsToTuple("b"));
        Tuple inputTuple = PigUtil.objectsToTuple(bag);
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ItemsSketch sketch = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes.get()), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertEquals((int)sketch.getNumActiveItems(), (int)2);
        Assert.assertEquals((long)sketch.getEstimate((Object)"a"), (long)3L);
        Assert.assertEquals((long)sketch.getEstimate((Object)"b"), (long)6L);
    }

    @Test
    public void accumulator() throws Exception {
        DataToFrequentStringsSketch func = new DataToFrequentStringsSketch("8");
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple("a"));
        inputTuple.set(0, (Object)bag);
        func.accumulate(inputTuple);
        inputTuple = TupleFactory.getInstance().newTuple(1);
        bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple("b"));
        bag.add(PigUtil.objectsToTuple("a", 2L));
        bag.add(PigUtil.objectsToTuple("b", 5L));
        inputTuple.set(0, (Object)bag);
        func.accumulate(inputTuple);
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ItemsSketch sketch = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes.get()), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertEquals((int)sketch.getNumActiveItems(), (int)2);
        Assert.assertEquals((long)sketch.getEstimate((Object)"a"), (long)3L);
        Assert.assertEquals((long)sketch.getEstimate((Object)"b"), (long)6L);
        func.cleanup();
        resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ItemsSketch sketch2 = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes.get()), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertTrue((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumActiveItems(), (int)0);
    }

    @Test
    public void algebraicInitial() throws Exception {
        DataToFrequentStringsSketch.Initial func = new DataToFrequentStringsSketch.Initial(null);
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple(null, null));
        bag.add(PigUtil.objectsToTuple(null, null));
        bag.add(PigUtil.objectsToTuple(null, null));
        inputTuple.set(0, (Object)bag);
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataBag resultBag = (DataBag)resultTuple.get(0);
        Assert.assertEquals((long)resultBag.size(), (long)3L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void algebraicIntermediateFinalWrongType() throws Exception {
        DataToFrequentStringsSketch.IntermediateFinal func = new DataToFrequentStringsSketch.IntermediateFinal("8");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(TupleFactory.getInstance().newTuple((Object)1.0));
        func.exec(TupleFactory.getInstance().newTuple((Object)bag));
    }

    @Test
    public void algebraicIntermediateFinal() throws Exception {
        DataToFrequentStringsSketch.IntermediateFinal func = new DataToFrequentStringsSketch.IntermediateFinal("8");
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        bag.add(PigUtil.objectsToTuple(PigUtil.tuplesToBag(PigUtil.objectsToTuple("a"))));
        ItemsSketch s = new ItemsSketch(8);
        s.update((Object)"b", 1L);
        s.update((Object)"a", 2L);
        s.update((Object)"b", 3L);
        bag.add(PigUtil.objectsToTuple(new DataByteArray(s.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe()))));
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        ItemsSketch sketch = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes.get()), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.assertEquals((int)sketch.getNumActiveItems(), (int)2);
        Assert.assertEquals((long)sketch.getEstimate((Object)"a"), (long)3L);
        Assert.assertEquals((long)sketch.getEstimate((Object)"b"), (long)4L);
    }
}

