/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.hll;

import java.io.IOException;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.pig.hll.AlgebraicInitial;
import org.apache.datasketches.pig.hll.DataToSketchAlgebraicFinal;
import org.apache.datasketches.pig.hll.DataToSketchAlgebraicIntermediate;
import org.apache.log4j.Logger;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;

public class DataToSketch
extends EvalFunc<DataByteArray>
implements Accumulator<DataByteArray>,
Algebraic {
    static final int DEFAULT_LG_K = 12;
    static final TgtHllType DEFAULT_HLL_TYPE = TgtHllType.HLL_4;
    private DataByteArray emptySketch_;
    private final int lgK_;
    private final TgtHllType tgtHllType_;
    private Union accumUnion_;
    private boolean isFirstCall_;

    public DataToSketch() {
        this(12, DEFAULT_HLL_TYPE);
    }

    public DataToSketch(String lgK) {
        this(Integer.parseInt(lgK), DEFAULT_HLL_TYPE);
    }

    public DataToSketch(String lgK, String tgtHllType) {
        this(Integer.parseInt(lgK), TgtHllType.valueOf((String)tgtHllType));
    }

    public DataToSketch(int lgK, TgtHllType tgtHllType) {
        this.lgK_ = lgK;
        this.tgtHllType_ = tgtHllType;
    }

    public DataByteArray exec(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Exec was used");
            this.isFirstCall_ = false;
        }
        if (inputTuple == null || inputTuple.size() == 0) {
            if (this.emptySketch_ == null) {
                this.emptySketch_ = new DataByteArray(new HllSketch(this.lgK_, this.tgtHllType_).toCompactByteArray());
            }
            return this.emptySketch_;
        }
        Union union = new Union(this.lgK_);
        DataBag bag = (DataBag)inputTuple.get(0);
        DataToSketch.updateUnion(bag, union);
        return new DataByteArray(union.getResult(this.tgtHllType_).toCompactByteArray());
    }

    public void accumulate(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Accumulator was used");
            this.isFirstCall_ = false;
        }
        if (inputTuple == null || inputTuple.size() == 0) {
            return;
        }
        DataBag bag = (DataBag)inputTuple.get(0);
        if (bag == null) {
            return;
        }
        if (this.accumUnion_ == null) {
            this.accumUnion_ = new Union(this.lgK_);
        }
        DataToSketch.updateUnion(bag, this.accumUnion_);
    }

    public DataByteArray getValue() {
        if (this.accumUnion_ == null) {
            if (this.emptySketch_ == null) {
                this.emptySketch_ = new DataByteArray(new HllSketch(this.lgK_, this.tgtHllType_).toCompactByteArray());
            }
            return this.emptySketch_;
        }
        return new DataByteArray(this.accumUnion_.getResult(this.tgtHllType_).toCompactByteArray());
    }

    public void cleanup() {
        this.accumUnion_ = null;
    }

    public String getInitial() {
        return AlgebraicInitial.class.getName();
    }

    public String getIntermed() {
        return DataToSketchAlgebraicIntermediate.class.getName();
    }

    public String getFinal() {
        return DataToSketchAlgebraicFinal.class.getName();
    }

    static void updateUnion(DataBag bag, Union union) throws ExecException {
        block10: for (Tuple innerTuple : bag) {
            Object f0 = innerTuple.get(0);
            if (f0 == null) continue;
            byte type = innerTuple.getType(0);
            switch (type) {
                case 1: {
                    continue block10;
                }
                case 6: {
                    union.update((long)((Byte)f0).byteValue());
                    continue block10;
                }
                case 10: {
                    union.update((long)((Integer)f0).intValue());
                    continue block10;
                }
                case 15: {
                    union.update(((Long)f0).longValue());
                    continue block10;
                }
                case 20: {
                    union.update((double)((Float)f0).floatValue());
                    continue block10;
                }
                case 25: {
                    union.update(((Double)f0).doubleValue());
                    continue block10;
                }
                case 50: {
                    DataByteArray dba = (DataByteArray)f0;
                    union.update(dba.get());
                    continue block10;
                }
                case 55: {
                    String str = (String)f0;
                    union.update(str.toCharArray());
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Field 0 of innerTuple must be one of NULL, BYTE, INTEGER, LONG, FLOAT, DOUBLE, BYTEARRAY or CHARARRAY. Given Type = " + DataType.findTypeName((byte)type) + ", Object = " + f0.toString());
        }
    }
}

