/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.hll;

import java.io.IOException;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class SketchToEstimateAndErrorBounds
extends EvalFunc<Tuple> {
    public Tuple exec(Tuple sketchTuple) throws IOException {
        if (sketchTuple == null || sketchTuple.size() == 0) {
            return null;
        }
        DataByteArray dba = (DataByteArray)sketchTuple.get(0);
        HllSketch sketch = HllSketch.wrap((Memory)Memory.wrap((byte[])dba.get()));
        Tuple outputTuple = TupleFactory.getInstance().newTuple(3);
        outputTuple.set(0, (Object)sketch.getEstimate());
        outputTuple.set(1, (Object)sketch.getLowerBound(2));
        outputTuple.set(2, (Object)sketch.getUpperBound(2));
        return outputTuple;
    }

    public Schema outputSchema(Schema input) {
        if (input == null) {
            return null;
        }
        try {
            Schema tupleSchema = new Schema();
            tupleSchema.add(new Schema.FieldSchema("Estimate", 25));
            tupleSchema.add(new Schema.FieldSchema("LowerBound", 25));
            tupleSchema.add(new Schema.FieldSchema("UpperBound", 25));
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), tupleSchema, 110));
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }
}

