/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.quantiles;

import java.io.IOException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

public class GetQuantileFromDoublesSketch
extends EvalFunc<Double> {
    public Double exec(Tuple input) throws IOException {
        if (input.size() != 2) {
            throw new IllegalArgumentException("expected two inputs: sketch and fraction");
        }
        if (!(input.get(0) instanceof DataByteArray)) {
            throw new IllegalArgumentException("expected a DataByteArray as a sketch, got " + input.get(0).getClass().getSimpleName());
        }
        DataByteArray dba = (DataByteArray)input.get(0);
        DoublesSketch sketch = DoublesSketch.wrap((Memory)Memory.wrap((byte[])dba.get()));
        if (!(input.get(1) instanceof Double)) {
            throw new IllegalArgumentException("expected a double value as a fraction, got " + input.get(1).getClass().getSimpleName());
        }
        double fraction = (Double)input.get(1);
        return sketch.getQuantile(fraction);
    }
}

