/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.sampling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.datasketches.pig.sampling.ReservoirSampling;
import org.apache.datasketches.sampling.ReservoirItemsSketch;
import org.apache.datasketches.sampling.ReservoirItemsUnion;
import org.apache.datasketches.sampling.SamplingPigUtil;
import org.apache.pig.AccumulatorEvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class ReservoirUnion
extends AccumulatorEvalFunc<Tuple> {
    private static final int DEFAULT_TARGET_K = 1024;
    private final int maxK_;
    private ReservoirItemsUnion<Tuple> union_;

    public ReservoirUnion(String kStr) {
        this.maxK_ = Integer.parseInt(kStr);
        if (this.maxK_ < 2) {
            throw new IllegalArgumentException("ReservoirUnion requires max reservoir size >= 2: " + this.maxK_);
        }
    }

    ReservoirUnion() {
        this.maxK_ = 1024;
    }

    public void accumulate(Tuple inputTuple) throws IOException {
        if (inputTuple == null || inputTuple.size() < 1 || inputTuple.isNull(0)) {
            return;
        }
        DataBag reservoirs = (DataBag)inputTuple.get(0);
        if (this.union_ == null) {
            this.union_ = ReservoirItemsUnion.newInstance((int)this.maxK_);
        }
        try {
            for (Tuple t : reservoirs) {
                long n = (Long)t.get(0);
                int k = (Integer)t.get(1);
                DataBag sampleBag = (DataBag)t.get(2);
                ArrayList<Tuple> samples = ReservoirSampling.dataBagToArrayList(sampleBag);
                this.union_.update(n, k, samples);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new ExecException("Cannot update union with given reservoir", (Throwable)e);
        }
    }

    public Tuple getValue() {
        if (this.union_ == null) {
            return null;
        }
        ReservoirItemsSketch resultSketch = this.union_.getResult();
        ArrayList data = SamplingPigUtil.getRawSamplesAsList(resultSketch);
        DataBag sampleBag = BagFactory.getInstance().newDefaultBag(data);
        return ReservoirSampling.createResultTuple(resultSketch.getN(), resultSketch.getK(), sampleBag);
    }

    public void cleanup() {
        this.union_ = null;
    }

    public Schema outputSchema(Schema input) {
        if (input != null && input.size() > 0) {
            try {
                List fields;
                Schema source = input;
                if (source.size() == 1 && source.getField((int)0).type == 120) {
                    source = source.getField((int)0).schema;
                }
                if (source.size() == 1 && source.getField((int)0).type == 110) {
                    source = source.getField((int)0).schema;
                }
                if ((fields = source.getFields()).size() == 3 && ((Schema.FieldSchema)fields.get((int)0)).type == 15 && ((Schema.FieldSchema)fields.get((int)1)).type == 10 && ((Schema.FieldSchema)fields.get((int)2)).type == 120) {
                    return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), source), source, 110));
                }
            }
            catch (FrontendException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

