/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.io.IOException;
import org.apache.datasketches.pig.tuple.Util;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.UpdatableSummary;
import org.apache.log4j.Logger;
import org.apache.pig.Accumulator;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;

public abstract class DataToSketch<U, S extends UpdatableSummary<U>>
extends EvalFunc<Tuple>
implements Accumulator<Tuple> {
    private final UpdatableSketchBuilder<U, S> sketchBuilder_;
    private UpdatableSketch<U, S> accumSketch_;
    private boolean isFirstCall_ = true;

    public DataToSketch(SummaryFactory<S> summaryFactory) {
        this(4096, 1.0f, summaryFactory);
    }

    public DataToSketch(int sketchSize, SummaryFactory<S> summaryFactory) {
        this(sketchSize, 1.0f, summaryFactory);
    }

    public DataToSketch(int sketchSize, float samplingProbability, SummaryFactory<S> summaryFactory) {
        this.sketchBuilder_ = new UpdatableSketchBuilder(summaryFactory).setNominalEntries(sketchSize).setSamplingProbability(samplingProbability);
    }

    public void accumulate(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"accumulate is used");
            this.isFirstCall_ = false;
        }
        if (this.accumSketch_ == null) {
            this.accumSketch_ = this.sketchBuilder_.build();
        }
        if (inputTuple.size() != 1) {
            throw new IllegalArgumentException("Input tuple must have 1 bag");
        }
        DataBag bag = (DataBag)inputTuple.get(0);
        DataToSketch.updateSketch(bag, this.accumSketch_);
    }

    public void cleanup() {
        this.accumSketch_ = null;
    }

    public Tuple getValue() {
        if (this.accumSketch_ == null) {
            this.accumSketch_ = this.sketchBuilder_.build();
        }
        return Util.tupleFactory.newTuple((Object)new DataByteArray(this.accumSketch_.compact().toByteArray()));
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"exec is used");
            this.isFirstCall_ = false;
        }
        if (inputTuple == null || inputTuple.size() == 0) {
            return null;
        }
        if (inputTuple.size() != 1) {
            throw new IllegalArgumentException("Input tuple must have 1 bag");
        }
        UpdatableSketch sketch = this.sketchBuilder_.build();
        DataBag bag = (DataBag)inputTuple.get(0);
        DataToSketch.updateSketch(bag, sketch);
        return Util.tupleFactory.newTuple((Object)new DataByteArray(sketch.compact().toByteArray()));
    }

    static <U, S extends UpdatableSummary<U>> void updateSketch(DataBag bag, UpdatableSketch<U, S> sketch) throws ExecException {
        if (bag == null) {
            throw new IllegalArgumentException("InputTuple.Field0: Bag may not be null");
        }
        block9: for (Tuple tuple : bag) {
            if (tuple.size() != 2) {
                throw new IllegalArgumentException("Inner tuple of input bag must have 2 fields.");
            }
            Object key = tuple.get(0);
            if (key == null) continue;
            Object value = tuple.get(1);
            switch (tuple.getType(0)) {
                case 6: {
                    sketch.update(((Byte)key).longValue(), value);
                    continue block9;
                }
                case 10: {
                    sketch.update(((Integer)key).longValue(), value);
                    continue block9;
                }
                case 15: {
                    sketch.update(((Long)key).longValue(), value);
                    continue block9;
                }
                case 20: {
                    sketch.update((double)((Float)key).floatValue(), value);
                    continue block9;
                }
                case 25: {
                    sketch.update(((Double)key).doubleValue(), value);
                    continue block9;
                }
                case 50: {
                    DataByteArray dba = (DataByteArray)key;
                    if (dba.size() == 0) continue block9;
                    sketch.update(dba.get(), value);
                    continue block9;
                }
                case 55: {
                    String s = key.toString();
                    if (s.isEmpty()) continue block9;
                    sketch.update(s, value);
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Field 0 must be one of NULL, BYTE, INTEGER, LONG, FLOAT, DOUBLE, BYTEARRAY or CHARARRAY. Type = " + DataType.findTypeName((byte)tuple.getType(0)) + ", Object = " + key.toString());
        }
    }
}

