/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import org.apache.derby.agg.Aggregator;
import org.apache.derbyTesting.functionTests.tests.lang.FullName;

public class GenericMode<B extends Comparable<B>>
implements Aggregator<B, B, GenericMode<B>> {
    private HashMap<B, Accumulator<B>> _accumulators;

    public void init() {
        this._accumulators = new HashMap();
    }

    public void accumulate(B b) {
        this.getAccumulator(b).add(1);
    }

    public void merge(GenericMode<B> genericMode) {
        HashMap<B, Accumulator<B>> hashMap = genericMode._accumulators;
        for (Comparable comparable : hashMap.keySet()) {
            this.getAccumulator(comparable).add(hashMap.get(comparable).getCount());
        }
    }

    public B terminate() {
        return this._accumulators.isEmpty() ? null : (B)Collections.max(this._accumulators.values()).getValue();
    }

    private Accumulator<B> getAccumulator(B b) {
        Accumulator<B> accumulator = this._accumulators.get(b);
        if (accumulator == null) {
            accumulator = new Accumulator<B>(b);
            this._accumulators.put(b, accumulator);
        }
        return accumulator;
    }

    public static final class Accumulator<B extends Comparable<B>>
    implements Comparable<Accumulator<B>> {
        private B _value;
        private int _count;

        public Accumulator(B b) {
            this._value = b;
            this._count = 0;
        }

        public void add(int n) {
            this._count += n;
        }

        public B getValue() {
            return this._value;
        }

        public int getCount() {
            return this._count;
        }

        @Override
        public int compareTo(Accumulator<B> accumulator) {
            int n = this._count - accumulator._count;
            if (n != 0) {
                return n;
            }
            return this._value.compareTo(accumulator._value);
        }
    }

    public static final class FullNameMode
    extends GenericMode<FullName> {
    }

    public static final class StringMode
    extends GenericMode<String> {
    }

    public static final class RealMode
    extends GenericMode<Float> {
    }

    public static final class DoubleMode
    extends GenericMode<Double> {
    }

    public static final class BigintMode
    extends GenericMode<Long> {
    }

    public static final class IntMode
    extends GenericMode<Integer> {
    }

    public static final class ShortMode
    extends GenericMode<Short> {
    }

    public static final class BooleanMode
    extends GenericMode<Boolean> {
    }

    public static final class BigDecimalMode
    extends GenericMode<BigDecimal> {
    }
}

