/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memory;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class MemoryLeakFixesTest
extends BaseJDBCTestCase {
    private static long HALFMB = 512000L;
    private static int numRows = 100;
    private static int numPreparedStmts = 2000;

    public MemoryLeakFixesTest(String string) {
        super(string);
    }

    public void testPrepStmtD210() throws Exception {
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        connection.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table t1 (lvc  LONG VARCHAR)");
        statement.close();
        String string = "insert into t1 values(?)";
        preparedStatement = connection.prepareStatement(string);
        for (int i = 0; i < numRows; ++i) {
            preparedStatement.setString(1, "Hello" + i);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        String string2 = "select * from t1";
        for (int i = 0; i < numPreparedStmts; ++i) {
            preparedStatement = connection.prepareStatement(string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                resultSet.getString(1);
            }
            resultSet.close();
            if (i % 100 != 0) continue;
            MemoryLeakFixesTest.runFinalizerIfNeeded();
        }
        connection.commit();
    }

    public void testReExecuteD557() throws Exception {
        MemoryLeakFixesTest.println("DERBY-557: reExecuteStatementTest() ");
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        for (int i = 0; i < 50000; ++i) {
            if (i % 1000 == 0) {
                MemoryLeakFixesTest.runFinalizerIfNeeded();
            }
            ResultSet resultSet = statement.executeQuery("values(1)");
        }
        connection.commit();
        statement.close();
        connection.close();
    }

    public void testResultSetgcD3316() throws Exception {
        MemoryLeakFixesTest.println("DERBY-3316: Multiple statement executions ");
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE TAB (col1 varchar(32672))");
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO TAB VALUES(?)");
        preparedStatement.setString(1, "hello");
        preparedStatement.executeUpdate();
        preparedStatement.setString(1, "hello");
        preparedStatement.executeUpdate();
        preparedStatement.close();
        for (int i = 0; i < 2000; ++i) {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * from tab");
            while (resultSet.next()) {
            }
            if (i % 100 != 0) continue;
            MemoryLeakFixesTest.runFinalizerIfNeeded();
        }
        connection.close();
        connection = this.getConnection();
        statement = connection.createStatement();
        statement.executeUpdate("DROP TABLE TAB");
        statement.close();
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRepeatedDatabaseCreationWithAutoStats() throws SQLException {
        File file = new File("system", "derby-memory-test");
        DataSource dataSource = JDBCDataSource.getDataSource("derby-memory-test");
        int n = 0;
        while (n < 20) {
            MemoryLeakFixesTest.println("-- " + n++);
            if (PrivilegedFileOpsForTests.exists(file)) {
                MemoryLeakFixesTest.assertDirectoryDeleted(file);
            }
            JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "create");
            Connection connection = dataSource.getConnection();
            JDBCDataSource.clearStringBeanProperty(dataSource, "createDatabase");
            connection.setAutoCommit(false);
            Statement statement = connection.createStatement();
            statement.executeUpdate("CREATE TABLE TEST (CINT INT)");
            statement.executeUpdate("CREATE INDEX NDX ON TEST (CINT)");
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO TEST VALUES ?");
            for (int i = 0; i < 200; ++i) {
                preparedStatement.setInt(1, i);
                preparedStatement.executeUpdate();
            }
            preparedStatement.close();
            connection.commit();
            JDBC.assertDrainResults(statement.executeQuery("SELECT * FROM TEST WHERE CINT=42"));
            statement.close();
            connection.rollback();
            connection.close();
            JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
            try {
                dataSource.getConnection();
                MemoryLeakFixesTest.fail((String)"Expected shutdown exception");
            }
            catch (SQLException sQLException) {
                MemoryLeakFixesTest.assertSQLState("08006", sQLException);
            }
            finally {
                JDBCDataSource.clearStringBeanProperty(dataSource, "shutdownDatabase");
            }
        }
        MemoryLeakFixesTest.assertTrue((boolean)PrivilegedFileOpsForTests.exists(file));
    }

    private static void runFinalizerIfNeeded() {
        Runtime runtime = Runtime.getRuntime();
        if (runtime.freeMemory() < HALFMB) {
            MemoryLeakFixesTest.println("Waiting for finalizer ");
            runtime.runFinalization();
        }
    }

    public static Test suite() {
        Test test = TestConfiguration.defaultSuite(MemoryLeakFixesTest.class);
        return test;
    }
}

