/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class TestRoutines {
    public static void installRoutines() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        TestRoutines.installRoutines(connection);
    }

    public static void installRoutines(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute("CREATE PROCEDURE TESTROUTINE.SET_SYSTEM_PROPERTY(IN PROPERTY_KEY VARCHAR(32000), IN PROPERTY_VALUE VARCHAR(32000)) NO SQL EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.TestRoutines.setSystemProperty' language java parameter style java");
        statement.execute("CREATE PROCEDURE TESTROUTINE.SLEEP(IN SLEEP_TIME_MS BIGINT) NO SQL EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.TestRoutines.sleep' language java parameter style java");
        statement.execute("CREATE FUNCTION TESTROUTINE.HAS_SECURITY_MANAGER() RETURNS INT NO SQL EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.TestRoutines.hasSecurityManager' language java parameter style java");
        statement.execute("CREATE FUNCTION TESTROUTINE.READ_FILE(FILE_NAME VARCHAR(60), ENCODING VARCHAR(60)) RETURNS VARCHAR(32000) NO SQL EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.TestRoutines.readFile' language java parameter style java");
        statement.close();
    }

    public static void setSystemProperty(final String string, final String string2) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.setProperty(string, string2);
                return null;
            }
        });
    }

    public static void sleep(long l) throws InterruptedException {
        Thread.sleep(l);
    }

    public static int hasSecurityManager() {
        return System.getSecurityManager() == null ? 0 : 1;
    }

    public static String readFile(final String string, String string2) throws PrivilegedActionException, IOException {
        int n;
        FileInputStream fileInputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

            @Override
            public FileInputStream run() throws FileNotFoundException {
                return new FileInputStream(string);
            }
        });
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new BufferedInputStream(fileInputStream, 32768), string2);
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStreamReader.read()) >= 0) {
            if (n <= 127) {
                stringBuffer.append((char)n);
                continue;
            }
            stringBuffer.append("\\u");
            String string3 = Integer.toHexString(n);
            switch (string3.length()) {
                case 2: {
                    stringBuffer.append("00");
                    break;
                }
                case 3: {
                    stringBuffer.append("0");
                }
            }
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }
}

