/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import org.apache.derbyTesting.functionTests.tests.lang.wisconsin;
import org.apache.derbyTesting.perf.clients.DBFiller;

public class WisconsinFiller
implements DBFiller {
    int numRows;

    public WisconsinFiller(int n) {
        this.numRows = n;
    }

    public WisconsinFiller() {
        this(10000);
    }

    @Override
    public void fill(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
        WisconsinFiller.dropTable(connection, "TENKTUP1");
        WisconsinFiller.dropTable(connection, "TENKTUP2");
        WisconsinFiller.dropTable(connection, "ONEKTUP");
        WisconsinFiller.dropTable(connection, "BPRIME");
        wisconsin.createTables(connection, false, this.numRows);
        connection.commit();
    }

    static void dropTable(Connection connection, String string) throws SQLException {
        Savepoint savepoint = connection.setSavepoint();
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate("DROP TABLE " + string);
        }
        catch (SQLException sQLException) {
            connection.rollback(savepoint);
        }
        statement.close();
        connection.releaseSavepoint(savepoint);
    }
}

