/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.impl.tools.ij.Session;
import org.apache.derby.impl.tools.ij.ijException;
import org.apache.derby.impl.tools.ij.util;
import org.apache.derby.impl.tools.ij.utilMain;
import org.apache.derby.tools.JDBCDisplayUtil;

class ConnectionEnv {
    Hashtable<String, Session> sessions = new Hashtable();
    private Session currSession;
    private String tag;
    private boolean only;
    private static final String CONNECTION_PROPERTY = "ij.connection";
    private String protocol;

    ConnectionEnv(int userNumber, boolean printUserNumber, boolean theOnly) {
        if (printUserNumber) {
            this.tag = "(" + (userNumber + 1) + ")";
        }
        this.only = theOnly;
    }

    void init(LocalizedOutput out) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Connection c = util.startJBMS(null, null);
        if (this.only) {
            Properties p = AccessController.doPrivileged(new PrivilegedAction<Properties>(){

                @Override
                public Properties run() {
                    return System.getProperties();
                }
            });
            this.protocol = p.getProperty("ij.protocol");
            String prefix = "ij.connection.";
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith(prefix)) continue;
                String name = key.substring(prefix.length());
                this.installConnection(name.toUpperCase(Locale.ENGLISH), p.getProperty(key), out);
            }
        }
        if (c != null) {
            String sname = "CONNECTION" + this.sessions.size();
            Session s = new Session(c, this.tag, sname);
            this.sessions.put(sname, s);
            this.currSession = s;
        }
    }

    void doPrompt(boolean newStatement, LocalizedOutput out) {
        if (this.currSession != null) {
            this.currSession.doPrompt(newStatement, out, this.sessions.size() > 1);
        } else {
            utilMain.doPrompt(newStatement, out, this.tag);
        }
    }

    Connection getConnection() {
        if (this.currSession == null) {
            return null;
        }
        return this.currSession.getConnection();
    }

    void addSession(Connection conn, String name) {
        String aName = name == null ? this.getUniqueConnectionName() : name;
        Session s = new Session(conn, this.tag, aName);
        this.sessions.put(aName, s);
        this.currSession = s;
    }

    public String getUniqueConnectionName() {
        int newNum = 0;
        boolean newConnectionNameOk = false;
        Object newConnectionName = "";
        while (!newConnectionNameOk) {
            newConnectionName = "CONNECTION" + newNum;
            newConnectionNameOk = true;
            Enumeration<String> e = this.sessions.keys();
            while (e.hasMoreElements() && newConnectionNameOk) {
                if (!e.nextElement().equals(newConnectionName)) continue;
                newConnectionNameOk = false;
            }
            ++newNum;
        }
        return newConnectionName;
    }

    Session getSession() {
        return this.currSession;
    }

    Hashtable<String, Session> getSessions() {
        return this.sessions;
    }

    Session getSession(String name) {
        return this.sessions.get(name);
    }

    Session setCurrentSession(String name) {
        this.currSession = this.sessions.get(name);
        return this.currSession;
    }

    boolean haveSession(String name) {
        return name != null && this.sessions.size() > 0 && null != this.sessions.get(name);
    }

    void removeCurrentSession() throws SQLException {
        if (this.currSession == null) {
            return;
        }
        this.sessions.remove(this.currSession.getName());
        this.currSession.close();
        this.currSession = null;
    }

    void removeSession(String name) throws SQLException {
        Session s = this.sessions.remove(name);
        s.close();
        if (this.currSession == s) {
            this.currSession = null;
        }
    }

    void removeAllSessions() throws SQLException {
        if (this.sessions == null || this.sessions.size() == 0) {
            return;
        }
        Enumeration<String> e = this.sessions.keys();
        while (e.hasMoreElements()) {
            String n = e.nextElement();
            this.removeSession(n);
        }
    }

    private void installConnection(String name, String value, LocalizedOutput out) throws SQLException {
        boolean noDriver = false;
        try {
            try {
                if (((String)value).startsWith("jdbc:")) {
                    util.loadDriverIfKnown((String)value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            DriverManager.getDriver((String)value);
        }
        catch (SQLException se) {
            noDriver = true;
        }
        if (noDriver && this.protocol != null) {
            value = this.protocol + (String)value;
        }
        if (this.sessions.get(name) != null) {
            throw ijException.alreadyHaveConnectionNamed(name);
        }
        try {
            String user = util.getSystemProperty("ij.user");
            String password = util.getSystemProperty("ij.password");
            Properties connInfo = util.updateConnInfo(user, password, null);
            Connection theConnection = DriverManager.getConnection((String)value, connInfo);
            this.addSession(theConnection, name);
        }
        catch (Throwable t) {
            JDBCDisplayUtil.ShowException(out, t);
        }
    }
}

