/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Barrier;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;

public class ErrorMessageTest
extends BaseJDBCTestCase {
    public ErrorMessageTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ErrorMessageTest");
        if (JDBC.vmSupportsJSR169()) {
            return baseTestSuite;
        }
        baseTestSuite.addTest(DatabasePropertyTestSetup.setLockTimeouts((Test)new ErrorMessageTest("testWaitTimeout"), 1, 2));
        baseTestSuite.addTest(DatabasePropertyTestSetup.setLockTimeouts((Test)new ErrorMessageTest("testDeadlockTimeout"), 1, 60));
        Test test = DatabasePropertyTestSetup.singleProperty((Test)baseTestSuite, "derby.locks.deadlockTrace", "true");
        return new CleanDatabaseTestSetup(test){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.executeUpdate("create table t (id int primary key, text varchar(10))");
                statement.executeUpdate("insert into t (id) values 1, 2");
            }
        };
    }

    public void testWaitTimeout() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        ErrorMessageTest.assertUpdateCount(statement, 1, "update t set text='xxx' where id=1");
        Connection connection = this.openDefaultConnection();
        Statement statement2 = connection.createStatement();
        try {
            JDBC.assertDrainResults(statement2.executeQuery("select * from t where id=1"));
            ErrorMessageTest.fail((String)"Expected lock timeout");
        }
        catch (SQLException sQLException) {
            ErrorMessageTest.assertSQLState("Not a timeout", "40XL1", sQLException);
            String[] stringArray = sQLException.getMessage().split("\n");
            ErrorMessageTest.assertEquals((String)"*** The following row is the victim ***", (String)stringArray[4]);
            ErrorMessageTest.assertEquals((String)"*** The above row is the victim ***", (String)stringArray[6]);
            String[] stringArray2 = stringArray[5].split(" *\\|");
            ErrorMessageTest.assertTrue((String)("Invalid XID string: " + stringArray2[0]), (boolean)stringArray2[0].matches("\\d+"));
            ErrorMessageTest.assertEquals((String)"Victim should be a row lock", (String)"ROW", (String)stringArray2[1]);
            ErrorMessageTest.assertEquals((String)"Victim should be a shared lock", (String)"S", (String)stringArray2[2]);
            ErrorMessageTest.assertEquals((String)"Victim should be waiting", (String)"WAIT", (String)stringArray2[5]);
            boolean bl = false;
            for (int i = 7; i < stringArray.length - 1; ++i) {
                String[] stringArray3 = stringArray[i].split(" *\\|");
                ErrorMessageTest.assertTrue((String)("Invalid XID string: " + stringArray3[0]), (boolean)stringArray3[0].matches("\\d+"));
                ErrorMessageTest.assertTrue((String)("Unexpected lock type: " + stringArray3[1]), (boolean)stringArray3[1].matches("ROW|TABLE"));
                ErrorMessageTest.assertTrue((String)("Unexpected lock mode: " + stringArray3[2]), (boolean)stringArray3[2].matches("S|X|IX|IS"));
                ErrorMessageTest.assertEquals((String)"Expected lock to be granted", (String)"GRANT", (String)stringArray3[5]);
                bl = true;
            }
            ErrorMessageTest.assertTrue((String)"No locks dumped", (boolean)bl);
        }
        statement.close();
        statement2.close();
        connection.close();
    }

    public void testDeadlockTimeout() throws SQLException, InterruptedException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        ErrorMessageTest.assertUpdateCount(statement, 1, "update t set text='xxx' where id=1");
        Connection connection = this.openDefaultConnection();
        connection.setAutoCommit(false);
        Statement statement2 = connection.createStatement();
        ErrorMessageTest.assertUpdateCount(statement2, 1, "update t set text='yyy' where id=2");
        PreparedStatement preparedStatement = this.prepareStatement("select * from t where id=2");
        final PreparedStatement preparedStatement2 = connection.prepareStatement("select * from t where id=1");
        final Barrier barrier = new Barrier(2);
        final SQLException[] sQLExceptionArray = new SQLException[2];
        final Throwable[] throwableArray = new Throwable[1];
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    barrier.await();
                    JDBC.assertDrainResults(preparedStatement2.executeQuery());
                }
                catch (SQLException sQLException) {
                    sQLExceptionArray[0] = sQLException;
                }
                catch (Throwable throwable) {
                    throwableArray[0] = throwable;
                }
            }
        });
        thread.start();
        barrier.await();
        try {
            JDBC.assertDrainResults(preparedStatement.executeQuery());
        }
        catch (SQLException sQLException) {
            sQLExceptionArray[1] = sQLException;
        }
        thread.join();
        if (throwableArray[0] != null) {
            ErrorMessageTest.fail("Helper thread failed unexpectedly", throwableArray[0]);
        }
        ErrorMessageTest.assertFalse((String)"No deadlock", (sQLExceptionArray[0] == null && sQLExceptionArray[1] == null ? 1 : 0) != 0);
        if (sQLExceptionArray[0] != null && sQLExceptionArray[1] != null) {
            ErrorMessageTest.printStackTrace(sQLExceptionArray[0]);
            ErrorMessageTest.printStackTrace(sQLExceptionArray[1]);
            ErrorMessageTest.fail((String)"Only one of the waiters should be aborted");
        }
        SQLException sQLException = sQLExceptionArray[0] == null ? sQLExceptionArray[1] : sQLExceptionArray[0];
        ErrorMessageTest.assertSQLState("Not a deadlock", "40001", sQLException);
        String[] stringArray = sQLException.getMessage().split("\n");
        ErrorMessageTest.assertEquals((String)"Unexpected number of lines in message", (int)8, (int)stringArray.length);
        Pattern[] patternArray = new Pattern[]{Pattern.compile("Lock : ROW, T, \\(\\d+,\\d+\\)"), Pattern.compile(" *Waiting XID : \\{\\d+, S\\} , APP, select \\* from t where id=(1|2)"), Pattern.compile(" *Granted XID : \\{\\d+, X\\} *")};
        for (int i = 0; i < patternArray.length * 2; ++i) {
            String string = stringArray[i + 1];
            Matcher matcher = patternArray[i % patternArray.length].matcher(string);
            ErrorMessageTest.assertTrue((String)("mismatch: " + string), (boolean)matcher.matches());
        }
        statement.close();
        statement2.close();
        connection.rollback();
        connection.close();
    }
}

