/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.functionTests.harness.JavaVersionHolder;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.DropDatabaseSetup;
import org.apache.derbyTesting.junit.SpawnedProcess;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.Utilities;

public abstract class BaseTestCase
extends TestCase {
    private static final String JACOCO_AGENT_PROP = "derby.tests.jacoco.agent";
    protected static final String ERRORSTACKTRACEFILE = "error-stacktrace.out";
    protected static final String DEFAULT_DB_DIR = "system";
    protected static final String DERBY_LOG = "derby.log";
    private static int debugPort;
    private static final PrintStream out;
    private static int spawnedCount;

    private BaseTestCase() {
    }

    public BaseTestCase(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        TestConfiguration testConfiguration = this.getTestConfiguration();
        boolean bl = testConfiguration.doTrace();
        boolean bl2 = testConfiguration.stopAfterFirstFail();
        long l = 0L;
        if (bl) {
            l = System.currentTimeMillis();
            out.println();
            String string = ((Object)((Object)this)).getClass().getName();
            string = Utilities.formatTestClassNames(string);
            out.print(BaseTestCase.traceClientType());
            out.print(string + "." + this.getName() + " ");
        }
        try {
            super.runBare();
        }
        catch (Throwable throwable) {
            PrintWriter printWriter = null;
            try {
                File file;
                Object object;
                String string = PrivilegedFileOpsForTests.getAbsolutePath(this.getFailureFolder());
                printWriter = new PrintWriter(PrivilegedFileOpsForTests.getFileOutputStream(new File(string, ERRORSTACKTRACEFILE), true));
                printWriter.println("[Error/failure logged at " + new Date() + "]");
                throwable.printStackTrace(printWriter);
                printWriter.println();
                File file2 = new File(DEFAULT_DB_DIR, DERBY_LOG);
                File file3 = new File(string, DERBY_LOG);
                PrivilegedFileOpsForTests.copy(file2, file3);
                for (int i = 0; i < 10; ++i) {
                    object = "derby-" + i + ".log";
                    file = new File(DEFAULT_DB_DIR, (String)object);
                    File file4 = new File(string, (String)object);
                    PrivilegedFileOpsForTests.copy(file, file4);
                }
                String string2 = TestConfiguration.getCurrent().getDefaultDatabaseName();
                object = new File(DEFAULT_DB_DIR, string2);
                file = new File(string, string2);
                PrivilegedFileOpsForTests.copy((File)object, file);
            }
            catch (IOException iOException) {
                BaseTestCase.printStackTrace(iOException);
                if (printWriter != null) {
                    printWriter.println("Copying derby.log or database failed:");
                    iOException.printStackTrace(printWriter);
                    printWriter.println();
                }
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
                if (!bl2) {
                    throw throwable;
                }
                throwable.printStackTrace(out);
                System.exit(1);
            }
        }
        finally {
            if (bl) {
                long l2 = System.currentTimeMillis() - l;
                out.print("used " + l2 + " ms ");
            }
        }
    }

    public final TestConfiguration getTestConfiguration() {
        return TestConfiguration.getCurrent();
    }

    public final File getFailureFolder() {
        return this.getTestConfiguration().getFailureFolder(this);
    }

    public static void alarm(String string) {
        out.println("ALARM: " + string);
    }

    public static void println(String string) {
        if (TestConfiguration.getCurrent().isVerbose()) {
            out.println("DEBUG: " + string);
            out.flush();
        }
    }

    public static void traceit(String string) {
        if (TestConfiguration.getCurrent().doTrace()) {
            out.println(string);
        }
    }

    public static void printStackTrace(Throwable throwable) {
        while (throwable != null) {
            throwable.printStackTrace(out);
            out.flush();
            if (!(throwable instanceof SQLException)) break;
            throwable = ((SQLException)throwable).getNextException();
        }
    }

    protected static void setSystemOut(PrintStream printStream) {
        System.setOut(printStream);
    }

    protected static void setSystemErr(PrintStream printStream) {
        System.setErr(printStream);
    }

    protected static void setSystemProperty(String string, String string2) {
        System.setProperty(string, string2);
    }

    public static void removeSystemProperty(String string) {
        System.getProperties().remove(string);
    }

    protected static String getSystemProperty(String string) {
        return System.getProperty(string);
    }

    protected static String[] getFilesWith(File file, String string) {
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.startsWith("javacore");
            }
        };
        return file.list(filenameFilter);
    }

    protected static URL getTestResource(String string) {
        return BaseTestCase.class.getClassLoader().getResource(string);
    }

    protected static InputStream openTestResource(URL uRL) throws IOException {
        return uRL.openStream();
    }

    public static void assertEquals(InputStream inputStream, InputStream inputStream2) throws IOException {
        if (inputStream == null || inputStream2 == null) {
            BaseTestCase.assertNull((String)"InputStream is2 is null, is1 is not", (Object)inputStream);
            BaseTestCase.assertNull((String)"InputStream is1 is null, is2 is not", (Object)inputStream2);
            return;
        }
        long l = 0L;
        int n = inputStream.read();
        int n2 = inputStream2.read();
        do {
            if (n != n2) {
                BaseTestCase.assertEquals((String)("Streams differ at index " + l), (int)n, (int)n2);
            }
            ++l;
            n = inputStream.read();
            n2 = inputStream2.read();
        } while (n != -1 || n2 != -1);
        inputStream.close();
        inputStream2.close();
    }

    public static void assertEquals(Reader reader, Reader reader2) throws IOException {
        long l = 0L;
        if (reader == null || reader2 == null) {
            BaseTestCase.assertNull((String)"Reader r2 is null, r1 is not", (Object)reader);
            BaseTestCase.assertNull((String)"Reader r1 is null, r2 is not", (Object)reader2);
            return;
        }
        int n = reader.read();
        int n2 = reader2.read();
        do {
            if (n != n2) {
                BaseTestCase.assertEquals((String)("Streams differ at index " + l), (int)n, (int)n2);
            }
            ++l;
            n = reader.read();
            n2 = reader2.read();
        } while (n != -1 || n2 != -1);
        reader.close();
        reader2.close();
    }

    public static void assertThrowableEquals(Throwable throwable, Throwable throwable2) {
        BaseTestCase.assertNotNull((String)"Passed-in throwable t1 cannot be null to assert detailed message", (Object)throwable);
        BaseTestCase.assertNotNull((String)"Passed-in throwable t2 cannot be null to assert detailed message", (Object)throwable2);
        BaseTestCase.assertEquals((String)"Throwable class types are different", (String)throwable.getClass().getName(), (String)throwable2.getClass().getName());
        BaseTestCase.assertEquals((String)"Detailed messages of the throwable's are different", (String)throwable.getMessage(), (String)throwable2.getMessage());
    }

    public static void assertEquals(byte[] byArray, byte[] byArray2) {
        if (BaseTestCase.assertSameNullness(byArray, byArray2)) {
            return;
        }
        BaseTestCase.assertEquals((int)byArray.length, (int)byArray2.length);
        for (int i = 0; i < byArray.length; ++i) {
            BaseTestCase.assertEquals((String)Integer.toString(i), (byte)byArray[i], (byte)byArray2[i]);
        }
    }

    public static boolean assertSameNullness(Object object, Object object2) {
        if (object == null) {
            BaseTestCase.assertNull((Object)object2);
            return true;
        }
        BaseTestCase.assertNotNull((Object)object2);
        return false;
    }

    public static void assertEquals(int[] nArray, int[] nArray2) {
        if (BaseTestCase.assertSameNullness(nArray, nArray2)) {
            return;
        }
        BaseTestCase.assertEquals((int)nArray.length, (int)nArray2.length);
        for (int i = 0; i < nArray.length; ++i) {
            BaseTestCase.assertEquals((String)Integer.toString(i), (int)nArray[i], (int)nArray2[i]);
        }
    }

    public static void assertEquals(long[] lArray, long[] lArray2) {
        if (BaseTestCase.assertSameNullness(lArray, lArray2)) {
            return;
        }
        BaseTestCase.assertEquals((int)lArray.length, (int)lArray2.length);
        for (int i = 0; i < lArray.length; ++i) {
            BaseTestCase.assertEquals((String)Integer.toString(i), (long)lArray[i], (long)lArray2[i]);
        }
    }

    public static void assertEquals(File file, File file2) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            BufferedInputStream bufferedInputStream2 = new BufferedInputStream(new FileInputStream(file2));
            BaseTestCase.assertEquals(bufferedInputStream, bufferedInputStream2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            BaseTestCase.fail((String)("FileNotFoundException in assertEquals(File,File): " + fileNotFoundException.getMessage()));
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            BaseTestCase.fail((String)("IOException in assertEquals(File, File): " + iOException.getMessage()));
            iOException.printStackTrace();
        }
    }

    public static void assertExecJavaCmdAsExpected(String[] stringArray, String[] stringArray2, int n) throws InterruptedException, IOException {
        int n2;
        Process process = BaseTestCase.execJavaCmd(stringArray2);
        String string = BaseTestCase.readProcessOutput(process);
        int n3 = process.exitValue();
        Object object = "";
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            object = (String)object + "\t[" + n2 + "]" + stringArray[n2] + "\n";
        }
        Assert.assertEquals((String)("expectedExitValue:" + n + " does not match exitValue:" + n3 + "\nexpected output strings:\n" + (String)object + " actual output:" + string), (int)n, (int)n3);
        if (stringArray != null) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                BaseTestCase.assertTrue((String)("Could not find expectedString:" + stringArray[n2] + " in output:" + string), (string.indexOf(stringArray[n2]) >= 0 ? 1 : 0) != 0);
            }
        }
    }

    public static Process execJavaCmd(String string, String string2, String[] stringArray, File file) throws IOException {
        return BaseTestCase.execJavaCmd(string, string2, stringArray, file, true);
    }

    public static Process execJavaCmd(String string, String string2, String[] stringArray, File file, boolean bl) throws IOException {
        boolean bl2 = JVMInfo.isModuleAware();
        return BaseTestCase.execJavaCmd(string, string2, stringArray, file, bl, bl2);
    }

    public static Process execJavaCmd(String string, String object, String[] stringArray, File file, boolean bl, boolean bl2) throws IOException {
        Object object2;
        boolean bl3 = stringArray.length > 0 && stringArray[0].equals("-jar");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string == null ? BaseTestCase.getJavaExecutableName() : string);
        if (BaseTestCase.isJ9Platform()) {
            String string2;
            arrayList.add("-jcl:foun11");
            object2 = BaseTestCase.getSystemProperty("emma.active");
            if (object2 != null) {
                arrayList.add("-Demma.active=" + (String)object2);
            }
            if ((string2 = BaseTestCase.getSystemProperty("jacoco.active")) != null) {
                arrayList.add("-Djacoco.active=" + string2);
            }
        }
        if (BaseTestCase.isCVM()) {
            arrayList.add("-Xmx32M");
        }
        if (BaseTestCase.runsWithEmma()) {
            arrayList.add("-Demma.coverage.out.file=" + BaseTestCase.getEmmaOutFile());
            if (object != null) {
                object = (String)object + File.pathSeparator + BaseTestCase.getEmmaJar().getPath();
            }
            if (bl3) {
                arrayList.add("-Xbootclasspath/a:" + BaseTestCase.getEmmaJar().getPath());
            }
        }
        if (BaseTestCase.runsWithJaCoCo()) {
            arrayList.add((String)object2 + (((String)(object2 = BaseTestCase.getSystemProperty(JACOCO_AGENT_PROP))).endsWith("=") ? "" : ",") + "destfile=" + BaseTestCase.getJaCoCoOutFile());
            arrayList.add("-Djacoco.active=");
        }
        if (BaseTestCase.isSunJVM() && Boolean.valueOf(BaseTestCase.getSystemProperty("derby.test.debugSubprocesses")).booleanValue()) {
            BaseTestCase.setupForDebuggerAttach(arrayList);
        }
        if (bl2) {
            arrayList.add("--add-modules");
            arrayList.add("org.apache.derby.tests,junit");
        }
        if (bl3) {
            BaseTestCase.assertNull((String)"Both -jar and classpath specified", (Object)object);
        } else if (bl) {
            object2 = object != null ? object : (bl2 ? JVMInfo.getSystemModulePath() : BaseTestCase.getSystemProperty("java.class.path"));
            if (BaseTestCase.isWindowsPlatform()) {
                object2 = ((String)object2).replace("file:/", "/");
            }
            if (bl2) {
                arrayList.add("-p");
            } else {
                arrayList.add("-classpath");
            }
            arrayList.add((String)object2);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = arrayList.toArray(stringArray);
        BaseTestCase.println("execute java command:");
        for (int i = 0; i < stringArray2.length; ++i) {
            BaseTestCase.println("command[" + i + "]" + stringArray2[i]);
        }
        try {
            return Runtime.getRuntime().exec(stringArray2, (String[])null, file);
        }
        catch (IOException iOException) {
            BaseTestCase.println("Failed to run command: " + iOException.getMessage());
            if (TestConfiguration.getCurrent().isVerbose()) {
                iOException.printStackTrace(out);
                out.flush();
            }
            throw iOException;
        }
    }

    public static Process execJavaCmd(String[] stringArray) throws IOException {
        return BaseTestCase.execJavaCmd(null, null, stringArray, null);
    }

    public static final String getJavaExecutableName() {
        Object object = BaseTestCase.getSystemProperty("com.ibm.oti.vm.exe");
        if (object == null) {
            object = BaseTestCase.getSystemProperty("java.vm.name");
            object = "CVM".equals(object) ? BaseTestCase.getSystemProperty("java.home") + File.separator + "bin" + File.separator + "cvm" : BaseTestCase.getSystemProperty("java.home") + File.separator + "bin" + File.separator + "java";
        }
        return object;
    }

    public static File currentDirectory() {
        return new File(BaseTestCase.getSystemProperty("user.dir"));
    }

    public static final boolean isJ9Platform() {
        return BaseTestCase.getSystemProperty("com.ibm.oti.vm.exe") != null;
    }

    public static final boolean isSunJVM() {
        String string = BaseTestCase.getSystemProperty("java.vendor");
        return "Sun Microsystems Inc.".equals(string) || "Oracle Corporation".equals(string);
    }

    public static boolean isCVM() {
        return "CVM".equals(BaseTestCase.getSystemProperty("java.vm.name"));
    }

    public static boolean isPhoneME() {
        return BaseTestCase.isCVM() && BaseTestCase.getSystemProperty("java.vm.version").startsWith("phoneme");
    }

    public static final boolean isPlatform(String string) {
        return BaseTestCase.getSystemProperty("os.name").equals(string);
    }

    public static final boolean isWindowsPlatform() {
        return BaseTestCase.getSystemProperty("os.name").startsWith("Windows");
    }

    public static final boolean shortCircuitFor_derby_7011() {
        boolean bl = JVMInfo.isModuleAware();
        boolean bl2 = BaseTestCase.getSystemProperty("user.dir").startsWith("/home/jenkins");
        return bl && bl2;
    }

    public static final boolean isJava5() {
        return BaseTestCase.getSystemProperty("java.version").startsWith("1.5");
    }

    public static final boolean isJava7() {
        return BaseTestCase.getSystemProperty("java.version").startsWith("1.7");
    }

    public static final boolean isJava8() {
        return BaseTestCase.getSystemProperty("java.version").startsWith("1.8");
    }

    public static final boolean runsWithEmma() {
        return BaseTestCase.getSystemProperty("java.class.path").indexOf("emma.jar") != -1;
    }

    public static boolean runsWithJaCoCo() {
        return TestConfiguration.jacocoEnabled;
    }

    private static synchronized File getJaCoCoOutFile() {
        return new File(BaseTestCase.currentDirectory(), "jacoco.exec." + ++spawnedCount);
    }

    private static synchronized File getEmmaOutFile() {
        return new File(BaseTestCase.currentDirectory(), "coverage-" + ++spawnedCount + ".ec");
    }

    public static URL getEmmaJar() {
        return TestConfiguration.getURL("com.vladium.emma.EMMAException");
    }

    public static int getClassVersionMajor() {
        String string = BaseTestCase.getSystemProperty("java.class.version");
        if (string == null) {
            BaseTestCase.println("VM doesn't have property java.class.version");
            return -1;
        }
        int n = string.indexOf(46);
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string.substring(0, n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean hasInterruptibleIO() {
        boolean bl = false;
        try {
            TestConfiguration testConfiguration = TestConfiguration.getCurrent();
            String string = BaseTestCase.getSystemProperty("derby.system.home");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append(File.separatorChar);
            stringBuffer.append(DERBY_LOG);
            String string2 = stringBuffer.toString();
            new File(string).mkdirs();
            new File(string2).createNewFile();
            RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "r");
            try {
                Thread.currentThread().interrupt();
                randomAccessFile.read();
            }
            finally {
                Thread.interrupted();
                randomAccessFile.close();
            }
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedIOException) {
                bl = true;
            }
            BaseTestCase.println("Could not test for interruptible IO, so assuming we don't have it: " + exception);
            exception.printStackTrace();
            return false;
        }
        return bl;
    }

    public static final boolean isIBMJVM() {
        return "IBM Corporation".equals(BaseTestCase.getSystemProperty("java.vendor"));
    }

    public static String readProcessOutput(Process process) throws InterruptedException {
        SpawnedProcess spawnedProcess = new SpawnedProcess(process, "readProcessOutput");
        spawnedProcess.suppressOutputOnComplete();
        try {
            spawnedProcess.complete();
        }
        catch (IOException iOException) {
            BaseTestCase.fail("process completion method failed", iOException);
        }
        String string = "<STDOUT>" + spawnedProcess.getFullServerOutput() + "<END STDOUT>\n";
        string = string + "<STDERR>" + spawnedProcess.getFullServerError() + "<END STDERR>\n";
        return string;
    }

    public static void assertDirectoryDeleted(File file) {
        int n;
        StringBuffer stringBuffer;
        File[] fileArray = null;
        int n2 = 0;
        while (n2 < 4) {
            try {
                Thread.sleep(n2 * 2000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                fileArray = PrivilegedFileOpsForTests.persistentRecursiveDelete(file);
                ++n2;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (n2 == 0) {
                    BaseTestCase.fail((String)("directory doesn't exist: " + PrivilegedFileOpsForTests.getAbsolutePath(file)));
                }
                System.out.println("<assertDirectoryDeleted> root directory unexpectedly gone - delayed, external or concurrent delete?");
                return;
            }
            if (fileArray.length == 0) {
                return;
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append("<assertDirectoryDeleted> attempt ").append(n2).append(" left ").append(fileArray.length).append(" files/dirs behind:");
            for (n = 0; n < fileArray.length; ++n) {
                stringBuffer.append(' ').append(n).append('=').append(fileArray[n]);
            }
            System.out.println(stringBuffer);
        }
        stringBuffer = new StringBuffer();
        for (n = 0; n < fileArray.length; ++n) {
            File file2 = fileArray[n];
            stringBuffer.append(PrivilegedFileOpsForTests.getAbsolutePath(file2)).append(' ').append(PrivilegedFileOpsForTests.getFileInfo(file2)).append(", ");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1).deleteCharAt(stringBuffer.length() - 1);
        BaseTestCase.fail((String)("Failed to delete " + fileArray.length + " files (root=" + PrivilegedFileOpsForTests.getAbsolutePath(file) + "): " + stringBuffer.toString()));
    }

    public static void removeDirectory(String string) {
        DropDatabaseSetup.removeDirectory(string);
    }

    public static void removeDirectory(File file) {
        DropDatabaseSetup.removeDirectory(file);
    }

    public static void removeFiles(String[] stringArray) {
        DropDatabaseSetup.removeFiles(stringArray);
    }

    public static void fail(String string, Throwable throwable) throws AssertionFailedError {
        throw BaseTestCase.newAssertionFailedError(string, throwable);
    }

    public static AssertionFailedError newAssertionFailedError(String string, Throwable throwable) {
        AssertionFailedError assertionFailedError = new AssertionFailedError(string);
        assertionFailedError.initCause(throwable);
        return assertionFailedError;
    }

    public static void assertLaunchedJUnitTestMethod(String string) throws Exception {
        String[] stringArray = new String[]{"junit.textui.TestRunner", "-m", string};
        BaseTestCase.assertExecJavaCmdAsExpected(new String[]{"OK (1 test)"}, stringArray, 0);
    }

    public static void assertLaunchedJUnitTestMethod(String string, String string2) throws Exception {
        String[] stringArray = new String[]{"-Dderby.tests.defaultDatabaseName=" + string2, "junit.textui.TestRunner", "-m", string};
        BaseTestCase.assertExecJavaCmdAsExpected(new String[]{"OK (1 test)"}, stringArray, 0);
    }

    public static void sleepAtLeastOneTick() {
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() == l) {
            BaseTestCase.sleep(1L);
        }
    }

    public static boolean vmAtLeast(int n, int n2) {
        String string = System.getProperty("java.version");
        JavaVersionHolder javaVersionHolder = new JavaVersionHolder(string);
        return javaVersionHolder.atLeast(n, n2);
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            BaseTestCase.alarm("sleep interrupted");
        }
    }

    private static String traceClientType() {
        if (TestConfiguration.getCurrent().getJDBCClient().isEmbedded()) {
            return "(emb)";
        }
        return "(net)";
    }

    private static void setupForDebuggerAttach(ArrayList<String> arrayList) {
        if (debugPort == 0) {
            String string = BaseTestCase.getSystemProperty("derby.test.debugPortBase");
            debugPort = 8800;
            if (string != null) {
                try {
                    debugPort = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        char c = 'y';
        String string = BaseTestCase.getSystemProperty("derby.test.debugSuspend");
        if (string != null && "n".equals(string.toLowerCase())) {
            c = 'n';
        }
        arrayList.add("-Xdebug");
        arrayList.add("-Xrunjdwp:transport=dt_socket,address=" + debugPort++ + ",server=y,suspend=" + c);
    }

    static {
        out = System.out;
        spawnedCount = 0;
    }
}

