/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.AggregateAliasInfo;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.DependencyDescriptor;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementColumnPermission;
import org.apache.derby.iapi.sql.dictionary.StatementGenericPermission;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.sql.dictionary.StatementRolePermission;
import org.apache.derby.iapi.sql.dictionary.StatementRoutinePermission;
import org.apache.derby.iapi.sql.dictionary.StatementSchemaPermission;
import org.apache.derby.iapi.sql.dictionary.StatementTablePermission;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.CreateSchemaConstantAction;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class DDLConstantAction
implements ConstantAction {
    DDLConstantAction() {
    }

    static SchemaDescriptor getAndCheckSchemaDescriptor(DataDictionary dd, UUID schemaId, String statementType) throws StandardException {
        SchemaDescriptor sd = dd.getSchemaDescriptor(schemaId, null);
        return sd;
    }

    static SchemaDescriptor getSchemaDescriptorForCreate(DataDictionary dd, Activation activation, String schemaName) throws StandardException {
        TransactionController tc = activation.getLanguageConnectionContext().getTransactionExecute();
        SchemaDescriptor sd = dd.getSchemaDescriptor(schemaName, tc, false);
        if (sd == null || sd.getUUID() == null) {
            block5: {
                CreateSchemaConstantAction csca = new CreateSchemaConstantAction(schemaName, null);
                if (activation.getLanguageConnectionContext().isInitialDefaultSchema(schemaName)) {
                    DDLConstantAction.executeCAPreferSubTrans(csca, tc, activation);
                } else {
                    try {
                        csca.executeConstantAction(activation);
                    }
                    catch (StandardException se) {
                        if (se.getMessageId().equals("X0Y68.S")) break block5;
                        throw se;
                    }
                }
            }
            sd = dd.getSchemaDescriptor(schemaName, tc, true);
        }
        return sd;
    }

    private static void executeCAPreferSubTrans(CreateSchemaConstantAction csca, TransactionController tc, Activation activation) throws StandardException {
        TransactionController useTc;
        TransactionController nestedTc = null;
        try {
            useTc = nestedTc = tc.startNestedUserTransaction(false, true);
        }
        catch (StandardException e) {
            SanityManager.THROWASSERT("Unexpected: not able to start nested transaction to auto-create schema", e);
            useTc = tc;
        }
        while (true) {
            try {
                csca.executeConstantAction(activation, useTc);
            }
            catch (StandardException se) {
                if (se.isLockTimeout()) {
                    if (!se.getMessageId().equals("40XL1.T.1") && useTc == nestedTc) {
                        useTc = tc;
                        nestedTc.destroy();
                        continue;
                    }
                } else if (se.getMessageId().equals("X0Y68.S")) break;
                if (useTc == nestedTc) {
                    nestedTc.destroy();
                }
                throw se;
            }
            break;
        }
        if (useTc == nestedTc) {
            nestedTc.commit();
            nestedTc.destroy();
        }
    }

    final void lockTableForDDL(TransactionController tc, long heapConglomerateNumber, boolean exclusiveMode) throws StandardException {
        ConglomerateController cc = tc.openConglomerate(heapConglomerateNumber, false, exclusiveMode ? 68 : 64, 7, 5);
        cc.close();
    }

    protected String constructToString(String statementType, String objectName) {
        return statementType + objectName;
    }

    protected void storeConstraintDependenciesOnPrivileges(Activation activation, Dependent dependent, UUID refTableUUID, ProviderInfo[] providers) throws StandardException {
        List<StatementPermission> requiredPermissionsList;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        String currentUser = lcc.getCurrentUserId(activation);
        SettableBoolean roleDepAdded = new SettableBoolean();
        if (!currentUser.equals(dd.getAuthorizationDatabaseOwner()) && (requiredPermissionsList = activation.getPreparedStatement().getRequiredPermissionsList()) != null && !requiredPermissionsList.isEmpty()) {
            for (StatementPermission statPerm : requiredPermissionsList) {
                PermissionsDescriptor permDesc;
                if (statPerm instanceof StatementTablePermission) {
                    StatementTablePermission statementTablePermission = (StatementTablePermission)statPerm;
                    if (statementTablePermission.getPrivType() != 2 || !statementTablePermission.getTableUUID().equals(refTableUUID)) {
                        continue;
                    }
                } else {
                    if (statPerm instanceof StatementSchemaPermission || statPerm instanceof StatementRolePermission || statPerm instanceof StatementGenericPermission) continue;
                    SanityManager.ASSERT(statPerm instanceof StatementRoutinePermission, "only StatementRoutinePermission expected");
                    StatementRoutinePermission rp = (StatementRoutinePermission)statPerm;
                    if (!this.inProviderSet(providers, rp.getRoutineUUID())) continue;
                }
                if ((permDesc = statPerm.getPermissionDescriptor(currentUser, dd)) == null) {
                    permDesc = statPerm.getPermissionDescriptor("PUBLIC", dd);
                    boolean roleUsed = false;
                    if (permDesc == null || permDesc instanceof ColPermsDescriptor && !((StatementColumnPermission)statPerm).allColumnsCoveredByUserOrPUBLIC(currentUser, dd)) {
                        roleUsed = true;
                        permDesc = DDLConstantAction.findRoleUsage(activation, statPerm);
                    }
                    if (!permDesc.checkOwner(currentUser)) {
                        dm.addDependency(dependent, permDesc, lcc.getContextManager());
                        if (roleUsed) {
                            DDLConstantAction.trackRoleDependency(activation, dependent, roleDepAdded);
                        }
                    }
                } else if (!permDesc.checkOwner(currentUser)) {
                    dm.addDependency(dependent, permDesc, lcc.getContextManager());
                    if (permDesc instanceof ColPermsDescriptor) {
                        StatementColumnPermission statementColumnPermission = (StatementColumnPermission)statPerm;
                        permDesc = statementColumnPermission.getPUBLIClevelColPermsDescriptor(currentUser, dd);
                        if (permDesc != null && permDesc.getObjectID() != null) {
                            dm.addDependency(dependent, permDesc, lcc.getContextManager());
                        }
                        if (!statementColumnPermission.allColumnsCoveredByUserOrPUBLIC(currentUser, dd)) {
                            DDLConstantAction.trackRoleDependency(activation, dependent, roleDepAdded);
                        }
                    }
                }
                if (statPerm instanceof StatementRoutinePermission) continue;
                break;
            }
        }
    }

    private static PermissionsDescriptor findRoleUsage(Activation activation, StatementPermission statPerm) throws StandardException {
        String graphGrant;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        String role = lcc.getCurrentRoleId(activation);
        PermissionsDescriptor permDesc = null;
        SanityManager.ASSERT(role != null, "Unexpected: current role is not set");
        RoleClosureIterator rci = dd.createRoleClosureIterator(activation.getTransactionController(), role, true);
        while (permDesc == null && (graphGrant = rci.next()) != null) {
            permDesc = statPerm.getPermissionDescriptor(graphGrant, dd);
        }
        SanityManager.ASSERT(permDesc != null, "Unexpected: Permission needs to be found via role");
        return permDesc;
    }

    private static void trackRoleDependency(Activation activation, Dependent dependent, SettableBoolean roleDepAdded) throws StandardException {
        if (!roleDepAdded.get()) {
            LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
            DataDictionary dd = lcc.getDataDictionary();
            DependencyManager dm = dd.getDependencyManager();
            String role = lcc.getCurrentRoleId(activation);
            RoleGrantDescriptor rgd = dd.getRoleDefinitionDescriptor(role);
            dm.addDependency(dependent, rgd, lcc.getContextManager());
            roleDepAdded.set(true);
        }
    }

    protected void storeViewTriggerDependenciesOnPrivileges(Activation activation, Dependent dependent) throws StandardException {
        List<StatementPermission> requiredPermissionsList;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        String dbo = dd.getAuthorizationDatabaseOwner();
        String currentUser = lcc.getCurrentUserId(activation);
        SettableBoolean roleDepAdded = new SettableBoolean();
        if (!currentUser.equals(dbo) && (requiredPermissionsList = activation.getPreparedStatement().getRequiredPermissionsList()) != null && !requiredPermissionsList.isEmpty()) {
            for (StatementPermission statPerm : requiredPermissionsList) {
                if (statPerm instanceof StatementSchemaPermission || statPerm instanceof StatementRolePermission) {
                    if (!(statPerm instanceof StatementRolePermission)) continue;
                    SanityManager.THROWASSERT("Unexpected StatementRolePermission");
                    continue;
                }
                PermissionsDescriptor permDesc = statPerm.getPermissionDescriptor(currentUser, dd);
                if (permDesc == null) {
                    permDesc = statPerm.getPermissionDescriptor("PUBLIC", dd);
                    boolean roleUsed = false;
                    if (permDesc == null || permDesc instanceof ColPermsDescriptor && !((StatementColumnPermission)statPerm).allColumnsCoveredByUserOrPUBLIC(currentUser, dd)) {
                        roleUsed = true;
                        permDesc = DDLConstantAction.findRoleUsage(activation, statPerm);
                    }
                    if (permDesc.checkOwner(currentUser)) continue;
                    dm.addDependency(dependent, permDesc, lcc.getContextManager());
                    if (!roleUsed) continue;
                    DDLConstantAction.trackRoleDependency(activation, dependent, roleDepAdded);
                    continue;
                }
                if (permDesc.checkOwner(currentUser)) continue;
                dm.addDependency(dependent, permDesc, lcc.getContextManager());
                if (!(permDesc instanceof ColPermsDescriptor)) continue;
                StatementColumnPermission statementColumnPermission = (StatementColumnPermission)statPerm;
                permDesc = statementColumnPermission.getPUBLIClevelColPermsDescriptor(currentUser, dd);
                if (permDesc != null && permDesc.getObjectID() != null) {
                    dm.addDependency(dependent, permDesc, lcc.getContextManager());
                }
                if (statementColumnPermission.allColumnsCoveredByUserOrPUBLIC(currentUser, dd)) continue;
                DDLConstantAction.trackRoleDependency(activation, dependent, roleDepAdded);
            }
        }
    }

    private boolean inProviderSet(ProviderInfo[] providers, UUID routineId) {
        if (providers == null) {
            return false;
        }
        for (int i = 0; i < providers.length; ++i) {
            if (!providers[i].getObjectId().equals(routineId)) continue;
            return true;
        }
        return false;
    }

    protected void addColumnDependencies(LanguageConnectionContext lcc, DataDictionary dd, TableDescriptor td, ColumnInfo ci) throws StandardException {
        ProviderInfo[] providers = ci.providers;
        if (providers != null) {
            DependencyManager dm = dd.getDependencyManager();
            ContextManager cm = lcc.getContextManager();
            int providerCount = providers.length;
            ColumnDescriptor cd = td.getColumnDescriptor(ci.name);
            DefaultDescriptor defDesc = cd.getDefaultDescriptor(dd);
            for (int px = 0; px < providerCount; ++px) {
                ProviderInfo pi = providers[px];
                DependableFinder finder = pi.getDependableFinder();
                UUID providerID = pi.getObjectId();
                Provider provider = (Provider)finder.getDependable(dd, providerID);
                dm.addDependency(defDesc, provider, cm);
            }
        }
    }

    protected void adjustUDTDependencies(LanguageConnectionContext lcc, DataDictionary dd, TableDescriptor td, ColumnInfo[] columnInfos, boolean dropWholeTable) throws StandardException {
        if (!dropWholeTable && columnInfos == null) {
            return;
        }
        TransactionController tc = lcc.getTransactionExecute();
        int changedColumnCount = columnInfos == null ? 0 : columnInfos.length;
        HashMap<String, AliasDescriptor> addUdtMap = new HashMap<String, AliasDescriptor>();
        HashMap<String, AliasDescriptor> dropUdtMap = new HashMap<String, AliasDescriptor>();
        HashSet<String> addColumnNames = new HashSet<String>();
        HashSet<String> dropColumnNames = new HashSet<String>();
        for (int i = 0; i < changedColumnCount; ++i) {
            ColumnInfo ci = columnInfos[i];
            AliasDescriptor ad = dd.getAliasDescriptorForUDT(tc, columnInfos[i].dataType);
            if (ad == null) continue;
            String key = ad.getObjectID().toString();
            if (ci.action == 0) {
                addColumnNames.add(ci.name);
                if (addUdtMap.get(key) != null) continue;
                addUdtMap.put(key, ad);
                continue;
            }
            if (ci.action != 1) continue;
            dropColumnNames.add(ci.name);
            dropUdtMap.put(key, ad);
        }
        if (!dropWholeTable && addUdtMap.isEmpty() && dropUdtMap.isEmpty()) {
            return;
        }
        ColumnDescriptorList cdl = td.getColumnDescriptorList();
        int totalColumnCount = cdl.size();
        for (int i = 0; i < totalColumnCount; ++i) {
            AliasDescriptor ad;
            ColumnDescriptor cd = cdl.elementAt(i);
            if (addColumnNames.contains(cd.getColumnName()) || dropColumnNames.contains(cd.getColumnName()) || (ad = dd.getAliasDescriptorForUDT(tc, cd.getType())) == null) continue;
            String key = ad.getObjectID().toString();
            if (dropWholeTable) {
                dropUdtMap.put(key, ad);
                continue;
            }
            if (addUdtMap.get(key) != null) {
                addUdtMap.remove(key);
            }
            if (dropUdtMap.get(key) == null) continue;
            dropUdtMap.remove(key);
        }
        this.adjustUDTDependencies(lcc, dd, (Dependent)td, addUdtMap, dropUdtMap);
    }

    private void adjustUDTDependencies(LanguageConnectionContext lcc, DataDictionary dd, Dependent dependent, HashMap<String, AliasDescriptor> addUdtMap, HashMap<String, AliasDescriptor> dropUdtMap) throws StandardException {
        if (addUdtMap.isEmpty() && dropUdtMap.isEmpty()) {
            return;
        }
        TransactionController tc = lcc.getTransactionExecute();
        DependencyManager dm = dd.getDependencyManager();
        ContextManager cm = lcc.getContextManager();
        for (AliasDescriptor ad : addUdtMap.values()) {
            dm.addDependency(dependent, ad, cm);
        }
        for (AliasDescriptor ad : dropUdtMap.values()) {
            DependencyDescriptor dep = new DependencyDescriptor(dependent, ad);
            dd.dropStoredDependency(dep, tc);
        }
    }

    protected void adjustUDTDependencies(LanguageConnectionContext lcc, DataDictionary dd, AliasDescriptor ad, boolean adding) throws StandardException {
        TypeDescriptor[] paramTypes;
        int i;
        AliasDescriptor returnTypeAD;
        TypeDescriptor rawReturnType;
        RoutineAliasInfo routineInfo = null;
        AggregateAliasInfo aggInfo = null;
        switch (ad.getAliasType()) {
            case 'G': {
                aggInfo = (AggregateAliasInfo)ad.getAliasInfo();
                break;
            }
            case 'F': 
            case 'P': {
                routineInfo = (RoutineAliasInfo)ad.getAliasInfo();
                break;
            }
            default: {
                return;
            }
        }
        TransactionController tc = lcc.getTransactionExecute();
        HashMap<String, AliasDescriptor> addUdtMap = new HashMap<String, AliasDescriptor>();
        HashMap<String, AliasDescriptor> dropUdtMap = new HashMap<String, AliasDescriptor>();
        HashMap<String, AliasDescriptor> udtMap = adding ? addUdtMap : dropUdtMap;
        TypeDescriptor typeDescriptor = rawReturnType = aggInfo != null ? aggInfo.getReturnType() : routineInfo.getReturnType();
        if (rawReturnType != null && (returnTypeAD = dd.getAliasDescriptorForUDT(tc, DataTypeDescriptor.getType(rawReturnType))) != null) {
            udtMap.put(returnTypeAD.getObjectID().toString(), returnTypeAD);
        }
        if (rawReturnType != null && rawReturnType.isRowMultiSet()) {
            TypeDescriptor[] columnTypes = rawReturnType.getRowTypes();
            int columnCount = columnTypes.length;
            for (i = 0; i < columnCount; ++i) {
                AliasDescriptor columnTypeAD = dd.getAliasDescriptorForUDT(tc, DataTypeDescriptor.getType(columnTypes[i]));
                if (columnTypeAD == null) continue;
                udtMap.put(columnTypeAD.getObjectID().toString(), columnTypeAD);
            }
        }
        if (aggInfo != null) {
            TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[1];
            v2 = typeDescriptorArray;
            typeDescriptorArray[0] = aggInfo.getForType();
        } else {
            v2 = paramTypes = routineInfo.getParameterTypes();
        }
        if (paramTypes != null) {
            int paramCount = paramTypes.length;
            for (i = 0; i < paramCount; ++i) {
                AliasDescriptor paramType = dd.getAliasDescriptorForUDT(tc, DataTypeDescriptor.getType(paramTypes[i]));
                if (paramType == null) continue;
                udtMap.put(paramType.getObjectID().toString(), paramType);
            }
        }
        this.adjustUDTDependencies(lcc, dd, ad, addUdtMap, dropUdtMap);
    }

    private static class SettableBoolean {
        boolean value = false;

        SettableBoolean() {
        }

        void set(boolean b) {
            this.value = b;
        }

        boolean get() {
            return this.value;
        }
    }
}

