/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.SQLException;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.AuthenticationTest;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class XADSAuthenticationTest
extends AuthenticationTest {
    public XADSAuthenticationTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("");
        }
        BaseTestSuite baseTestSuite = new BaseTestSuite("XADSAuthenticationTest");
        baseTestSuite.addTest(XADSAuthenticationTest.baseSuite("XADSAuthenticationTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(XADSAuthenticationTest.baseSuite("XADSAuthenticationTest:client")));
        return baseTestSuite;
    }

    public static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("XADSAuthenticationTest");
        XADSAuthenticationTest xADSAuthenticationTest = new XADSAuthenticationTest("testConnectShutdownAuthentication");
        XADSAuthenticationTest.setBaseProps(baseTestSuite, (Test)xADSAuthenticationTest);
        xADSAuthenticationTest = new XADSAuthenticationTest("testUserFunctions");
        XADSAuthenticationTest.setBaseProps(baseTestSuite, (Test)xADSAuthenticationTest);
        xADSAuthenticationTest = new XADSAuthenticationTest("testNotFullAccessUsers");
        XADSAuthenticationTest.setBaseProps(baseTestSuite, (Test)xADSAuthenticationTest);
        xADSAuthenticationTest = new XADSAuthenticationTest("testChangePasswordAndDatabasePropertiesOnly");
        XADSAuthenticationTest.setBaseProps(baseTestSuite, (Test)xADSAuthenticationTest);
        xADSAuthenticationTest = new XADSAuthenticationTest("testGreekCharacters");
        XADSAuthenticationTest.setBaseProps(baseTestSuite, (Test)xADSAuthenticationTest);
        xADSAuthenticationTest = new XADSAuthenticationTest("testSystemShutdown");
        XADSAuthenticationTest.setBaseProps(baseTestSuite, (Test)xADSAuthenticationTest);
        return TestConfiguration.singleUseDatabaseDecorator((Test)baseTestSuite);
    }

    @Override
    protected void assertConnectionOK(String string, String string2, String string3) throws SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xADataSource, "databaseName", string);
        xADataSource.getXAConnection(string2, string3).close();
    }

    @Override
    protected void assertConnectionWOUPOK(String string, String string2, String string3) throws SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xADataSource, "databaseName", string);
        JDBCDataSource.setBeanProperty(xADataSource, "user", string2);
        JDBCDataSource.setBeanProperty(xADataSource, "password", string3);
        xADataSource.getXAConnection().close();
    }

    @Override
    protected void assertConnectionFail(String string, String string2, String string3, String string4) throws SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xADataSource, "databaseName", string2);
        try {
            xADataSource.getXAConnection(string3, string4);
            XADSAuthenticationTest.fail((String)"Connection should've been refused/failed");
        }
        catch (SQLException sQLException) {
            XADSAuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    @Override
    protected void assertConnectionWOUPFail(String string, String string2, String string3, String string4) throws SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xADataSource, "databaseName", string2);
        JDBCDataSource.setBeanProperty(xADataSource, "user", string3);
        JDBCDataSource.setBeanProperty(xADataSource, "password", string4);
        try {
            xADataSource.getXAConnection();
            XADSAuthenticationTest.fail((String)"Connection should've been refused/failed");
        }
        catch (SQLException sQLException) {
            XADSAuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    @Override
    protected void assertShutdownUsingSetShutdownOK(String string, String string2, String string3) throws SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xADataSource, "databaseName", string);
        JDBCDataSource.setBeanProperty(xADataSource, "shutdownDatabase", "shutdown");
        try {
            xADataSource.getXAConnection(string2, string3);
            XADSAuthenticationTest.fail((String)"expected a failed shutdown connection");
        }
        catch (SQLException sQLException) {
            XADSAuthenticationTest.assertSQLState("08006", sQLException);
        }
    }

    @Override
    protected void assertShutdownUsingConnAttrsOK(String string, String string2, String string3) throws SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xADataSource, "connectionAttributes", "shutdown=true");
        try {
            xADataSource.getXAConnection(string2, string3);
            XADSAuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException sQLException) {
            XADSAuthenticationTest.assertSQLState("08006", sQLException);
        }
    }

    @Override
    protected void assertShutdownWOUPOK(String string, String string2, String string3) throws SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xADataSource, "databaseName", string);
        JDBCDataSource.setBeanProperty(xADataSource, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(xADataSource, "user", string2);
        JDBCDataSource.setBeanProperty(xADataSource, "password", string3);
        try {
            xADataSource.getXAConnection();
            XADSAuthenticationTest.fail((String)"expected a failed shutdown connection");
        }
        catch (SQLException sQLException) {
            XADSAuthenticationTest.assertSQLState("08006", sQLException);
        }
    }

    @Override
    protected void assertShutdownFail(String string, String string2, String string3, String string4) throws SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xADataSource, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(xADataSource, "databaseName", string2);
        try {
            xADataSource.getXAConnection(string3, string4);
            XADSAuthenticationTest.fail((String)"expected failed shutdown");
        }
        catch (SQLException sQLException) {
            XADSAuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    @Override
    protected void assertShutdownWOUPFail(String string, String string2, String string3, String string4) throws SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xADataSource, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(xADataSource, "databaseName", string2);
        JDBCDataSource.setBeanProperty(xADataSource, "user", string3);
        JDBCDataSource.setBeanProperty(xADataSource, "password", string4);
        try {
            xADataSource.getXAConnection();
            XADSAuthenticationTest.fail((String)"expected failed shutdown");
        }
        catch (SQLException sQLException) {
            XADSAuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    @Override
    protected void assertSystemShutdownOK(String string, String string2, String string3) throws SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xADataSource, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(xADataSource, "databaseName", string);
        JDBCDataSource.setBeanProperty(xADataSource, "user", string2);
        JDBCDataSource.setBeanProperty(xADataSource, "password", string3);
        try {
            xADataSource.getXAConnection();
            XADSAuthenticationTest.fail((String)"expected system shutdown resulting in XJ015 error");
        }
        catch (SQLException sQLException) {
            XADSAuthenticationTest.assertSQLState("XJ015", sQLException);
        }
    }

    @Override
    protected void assertSystemShutdownFail(String string, String string2, String string3, String string4) throws SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        JDBCDataSource.setBeanProperty(xADataSource, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(xADataSource, "databaseName", string2);
        JDBCDataSource.setBeanProperty(xADataSource, "user", string3);
        JDBCDataSource.setBeanProperty(xADataSource, "password", string4);
        try {
            xADataSource.getXAConnection();
            XADSAuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException sQLException) {
            XADSAuthenticationTest.assertSQLState(string, sQLException);
        }
    }

    @Override
    public void assertConnectionFail(String string) throws SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        if (XADSAuthenticationTest.usingDerbyNetClient()) {
            JDBCDataSource.setBeanProperty(xADataSource, "user", "APP");
        } else {
            JDBCDataSource.clearStringBeanProperty(xADataSource, "user");
        }
        JDBCDataSource.clearStringBeanProperty(xADataSource, "password");
        JDBCDataSource.setBeanProperty(xADataSource, "databaseName", string);
        try {
            xADataSource.getXAConnection();
            XADSAuthenticationTest.fail((String)"expected connection to fail");
        }
        catch (SQLException sQLException) {
            XADSAuthenticationTest.assertSQLState("08004", sQLException);
        }
    }
}

