/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.IOException;
import java.io.InputStream;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.analyser.ImageReader;

public class BMPReader
implements ImageReader {
    protected static final int BMP_SIG_LENGTH = 46;
    private static final int WIDTH_OFFSET = 18;
    private static final int HEIGHT_OFFSET = 22;
    private static final int HRES_OFFSET = 38;
    private static final int VRES_OFFSET = 42;

    public FopImage.ImageInfo verifySignature(String uri, InputStream bis, FOUserAgent ua) throws IOException {
        boolean supported;
        byte[] header = this.getDefaultHeader(bis);
        boolean bl = supported = header[0] == 66 && header[1] == 77;
        if (supported) {
            FopImage.ImageInfo info = this.getDimension(header);
            info.originalURI = uri;
            info.mimeType = this.getMimeType();
            info.inputStream = bis;
            return info;
        }
        return null;
    }

    public String getMimeType() {
        return "image/bmp";
    }

    private FopImage.ImageInfo getDimension(byte[] header) {
        FopImage.ImageInfo info = new FopImage.ImageInfo();
        int byte1 = header[18] & 0xFF;
        int byte2 = header[19] & 0xFF;
        int byte3 = header[20] & 0xFF;
        int byte4 = header[21] & 0xFF;
        long l = byte4 << 24 | byte3 << 16 | byte2 << 8 | byte1;
        info.width = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        byte1 = header[22] & 0xFF;
        byte2 = header[23] & 0xFF;
        byte3 = header[24] & 0xFF;
        byte4 = header[25] & 0xFF;
        l = byte4 << 24 | byte3 << 16 | byte2 << 8 | byte1;
        info.height = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        byte4 = header[41] & 0xFF;
        byte3 = header[40] & 0xFF;
        byte2 = header[39] & 0xFF;
        byte1 = header[38] & 0xFF;
        l = byte4 << 24 | byte3 << 16 | byte2 << 8 | byte1;
        if (l > 0L) {
            info.dpiHorizontal = (double)l / 39.37;
        }
        if ((l = (long)((byte4 = header[45] & 0xFF) << 24 | (byte3 = header[44] & 0xFF) << 16 | (byte2 = header[43] & 0xFF) << 8 | (byte1 = header[42] & 0xFF))) > 0L) {
            info.dpiVertical = (double)l / 39.37;
        }
        return info;
    }

    private byte[] getDefaultHeader(InputStream imageStream) throws IOException {
        byte[] header = new byte[46];
        try {
            imageStream.mark(47);
            imageStream.read(header);
            imageStream.reset();
        }
        catch (IOException ex) {
            try {
                imageStream.reset();
            }
            catch (IOException exbis) {
                // empty catch block
            }
            throw ex;
        }
        return header;
    }
}

