/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.outlet;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.outlet.OutletSaxHandler;
import org.apache.torque.generator.configuration.outlet.UntypedOutletSaxHandlerFactory;
import org.apache.torque.generator.qname.QualifiedName;
import org.xml.sax.SAXException;

public class ReflectionOutletSaxHandlerFactory
implements UntypedOutletSaxHandlerFactory {
    private static final String SAX_HANDLER_CLASSNAME_SUFFIX = "SaxHandler";
    private static final String DEFAULT_PACKAGE = "org.apache.torque.generator.configuration.outlet";
    private static Log log = LogFactory.getLog(ReflectionOutletSaxHandlerFactory.class);
    private String saxHandlerPackage = "org.apache.torque.generator.configuration.outlet";

    public ReflectionOutletSaxHandlerFactory() {
    }

    public ReflectionOutletSaxHandlerFactory(String saxHandlerPackage) {
        this.saxHandlerPackage = saxHandlerPackage;
    }

    public String getType() {
        return null;
    }

    @Override
    public final OutletSaxHandler getOutletSaxHandler(String outletType, QualifiedName outletName, ConfigurationProvider configurationProvider, UnitDescriptor unitDescriptor, ConfigurationHandlers configurationHandlers) throws SAXException {
        OutletSaxHandler outletSaxHandler;
        Constructor<?> constructor;
        Class<?> handlerClass;
        String fullyQualifiedSaxHandlerName = this.getFullyQualifiedHandlerClassName(outletType);
        try {
            ClassLoader classLoader = unitDescriptor.getClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            handlerClass = Class.forName(fullyQualifiedSaxHandlerName, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            constructor = handlerClass.getConstructor(QualifiedName.class, ConfigurationProvider.class, UnitDescriptor.class, ConfigurationHandlers.class);
        }
        catch (NoSuchMethodException e) {
            throw new SAXException("Class " + handlerClass.getName() + " has no constructor for types " + QualifiedName.class.getName() + "," + ConfigurationProvider.class.getName() + "," + UnitDescriptor.class.getName() + "," + ConfigurationHandlers.class.getName());
        }
        try {
            outletSaxHandler = (OutletSaxHandler)constructor.newInstance(outletName, configurationProvider, unitDescriptor, configurationHandlers);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new SAXException("The class " + handlerClass.getName() + " is abstract", e);
        }
        catch (IllegalAccessException e) {
            throw new SAXException("Constructor of class " + handlerClass.getName() + " is inaccessible", e);
        }
        catch (InvocationTargetException e) {
            throw new SAXException("Constructor of class " + handlerClass.getName() + " has thrown an exception", e);
        }
        return outletSaxHandler;
    }

    @Override
    public boolean canHandle(String type, UnitDescriptor unitDescriptor) {
        Class<?> handlerClass;
        String fullyQualifiedSaxHandlerName = this.getFullyQualifiedHandlerClassName(type);
        log.debug((Object)("canHandle: Using class name " + fullyQualifiedSaxHandlerName));
        try {
            ClassLoader classLoader = unitDescriptor.getClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            handlerClass = Class.forName(fullyQualifiedSaxHandlerName, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"canHandle: class does not exist, returning false");
            return false;
        }
        if (!OutletSaxHandler.class.isAssignableFrom(handlerClass)) {
            log.debug((Object)"canHandle: class is no OutletSaxHandlerreturning false");
            return false;
        }
        return true;
    }

    protected String getFullyQualifiedHandlerClassName(String type) {
        String saxHandlerClassName = StringUtils.capitalize((String)type) + SAX_HANDLER_CLASSNAME_SUFFIX;
        String fullyQualifiedSaxHandlerName = this.saxHandlerPackage + "." + saxHandlerClassName;
        return fullyQualifiedSaxHandlerName;
    }
}

