/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration;

import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.UnitDescriptor;

public final class ClassHelper {
    private ClassHelper() {
    }

    public static Object getInstance(String className, Class<?> isInstanceOf, UnitDescriptor unitDescriptor) throws ConfigurationException {
        Object result;
        if (className == null) {
            return null;
        }
        try {
            ClassLoader classLoader = unitDescriptor.getClassLoader();
            if (classLoader == null) {
                classLoader = ClassHelper.class.getClassLoader();
            }
            Class<?> clazz = Class.forName(className, true, classLoader);
            result = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("The class " + className + " could not be found.", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Instantiating " + className + " is not allowed", e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("The class " + className + " has no standard constructor.", e);
        }
        catch (Exception e) {
            throw new ConfigurationException("The class " + className + " has an error.", e);
        }
        if (isInstanceOf != null && !isInstanceOf.isInstance(result)) {
            throw new ConfigurationException("Classes with class : " + className + " are not instances of " + isInstanceOf.getName());
        }
        return result;
    }
}

