/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.DelReviewMgr;
import org.apache.directory.fortress.core.ReviewMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserAdminRole;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.web.model.SerializableList;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserListModel
extends Model<SerializableList<User>> {
    private static final long serialVersionUID = 1L;
    @SpringBean
    private ReviewMgr reviewMgr;
    @SpringBean
    private DelReviewMgr delReviewMgr;
    private static final Logger LOG = LoggerFactory.getLogger((String)UserListModel.class.getName());
    private User user;
    private Permission perm;
    private SerializableList<User> users = null;

    public UserListModel(Session session) {
        this.init(session);
    }

    public UserListModel(User user, Session session) {
        this.user = user;
        this.init(session);
        LOG.debug("constructor userId: " + user.getUserId());
    }

    public UserListModel(Permission perm, Session session) {
        this.perm = perm;
        this.init(session);
        LOG.debug("constructor perm: " + perm.getObjName());
    }

    private void init(Session session) {
        Injector.get().inject((Object)this);
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.reviewMgr.setAdmin(session);
        }
    }

    public SerializableList<User> getObject() {
        if (this.users != null) {
            LOG.debug(".getObject count: " + this.users.size());
            return this.users;
        }
        if (this.user == null && this.perm == null) {
            LOG.debug(".getObject null");
        } else {
            this.users = new SerializableList(this.getList(this.user));
        }
        if (this.users == null) {
            this.users = new SerializableList(new ArrayList());
        }
        return this.users;
    }

    public void setObject(SerializableList<User> object) {
        LOG.debug(".setObject count: " + object.size());
        this.users = object;
    }

    public void detach() {
        this.users = null;
        this.user = null;
    }

    public List<User> getList(User user) {
        List<User> usersList = null;
        try {
            if (this.perm != null) {
                Set users = this.reviewMgr.authorizedPermissionUsers(this.perm);
                if (CollectionUtils.isNotEmpty((Collection)users)) {
                    usersList = new ArrayList();
                    for (String userId : users) {
                        User user1 = this.reviewMgr.readUser(new User(userId));
                        usersList.add(user1);
                    }
                }
            } else {
                usersList = StringUtils.isNotEmpty((String)user.getOu()) ? this.reviewMgr.findUsers(new OrgUnit(user.getOu(), OrgUnit.Type.USER)) : (CollectionUtils.isNotEmpty((Collection)user.getRoles()) ? this.reviewMgr.assignedUsers(new Role(((UserRole)user.getRoles().get(0)).getName())) : (CollectionUtils.isNotEmpty((Collection)user.getAdminRoles()) ? this.delReviewMgr.assignedUsers(new AdminRole(((UserAdminRole)user.getAdminRoles().get(0)).getName())) : this.reviewMgr.findUsers(user)));
            }
            if (CollectionUtils.isNotEmpty(usersList)) {
                Collections.sort(usersList, new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (SecurityException se) {
            String error = ".getList caught SecurityException=" + se;
            throw new RuntimeException(error, se);
        }
        return usersList;
    }
}

