/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.control;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.directory.fortress.core.AccessMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.web.control.SecUtils;
import org.apache.directory.fortress.web.control.WicketSession;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureIndicatingAjaxButton
extends IndicatingAjaxButton {
    Permission perm;
    @SpringBean
    private AccessMgr accessMgr;
    private static final Logger LOG = LoggerFactory.getLogger((String)SecureIndicatingAjaxButton.class.getName());

    public SecureIndicatingAjaxButton(Component component, String id, String objectName, String opName) {
        super(id);
        this.perm = new Permission(objectName, opName);
        if (SecUtils.IS_PERM_CACHED) {
            if (!SecUtils.isFound((Permission)this.perm, (Component)this)) {
                this.setVisible(false);
            }
        } else {
            boolean isAuthorized = false;
            try {
                WicketSession session = (WicketSession)component.getSession();
                isAuthorized = this.accessMgr.checkAccess(session.getSession(), this.perm);
                LOG.info("Fortress checkAccess objectName: " + objectName + " operationName: " + opName + " userId: " + session.getSession().getUserId() + " result: " + isAuthorized);
            }
            catch (SecurityException se) {
                String error = "Fortress SecurityException checkAccess objectName: " + objectName + " operationName: " + opName + " error=" + se;
                LOG.error(error);
            }
            if (!isAuthorized) {
                this.setVisible(false);
            }
        }
    }

    public SecureIndicatingAjaxButton(String id, String roleName) {
        super(id);
        HttpServletRequest servletReq = (HttpServletRequest)this.getRequest().getContainerRequest();
        if (!SecUtils.isAuthorized((String)roleName, (HttpServletRequest)servletReq)) {
            this.setVisible(false);
        }
    }

    public SecureIndicatingAjaxButton(String id, String objName, String opName) {
        super(id);
        LOG.debug("load button perm objName: " + objName + " opName: " + opName);
        if (!SecUtils.isFound((Permission)new Permission(objName, opName), (Component)this)) {
            this.setVisible(false);
            LOG.info("perm objName: " + objName + " opName: " + opName + ", not found in session");
        }
    }

    protected boolean checkAccess(String objectName, String opName) {
        boolean isAuthorized = false;
        try {
            WicketSession session = (WicketSession)this.getSession();
            Permission permission = new Permission(objectName, opName);
            isAuthorized = this.accessMgr.checkAccess(session.getSession(), permission);
            LOG.info("Fortress checkAccess objectName: " + permission.getObjName() + " operationName: " + permission.getOpName() + " userId: " + session.getSession().getUserId() + " result: " + isAuthorized);
        }
        catch (SecurityException se) {
            String error = "Fortress SecurityException checkAccess objectName: " + this.perm.getObjName() + " operationName: " + this.perm.getOpName() + " error=" + se;
            LOG.error(error);
        }
        return isAuthorized;
    }

    protected boolean checkAccess() {
        boolean isAuthorized = false;
        try {
            WicketSession session = (WicketSession)this.getSession();
            isAuthorized = this.accessMgr.checkAccess(session.getSession(), this.perm);
            LOG.info("Fortress checkAccess objName: " + this.perm.getObjName() + " opName: " + this.perm.getOpName() + " userId: " + session.getSession().getUserId() + " result: " + isAuthorized);
        }
        catch (SecurityException se) {
            String error = "Fortress SecurityException checkAccess objName: " + this.perm.getObjName() + " opName: " + this.perm.getOpName() + " error=" + se;
            LOG.error(error);
        }
        return isAuthorized;
    }

    protected boolean checkAccess(String objectId) {
        boolean isAuthorized = false;
        try {
            WicketSession session = (WicketSession)this.getSession();
            Permission finePerm = new Permission(this.perm.getObjName(), this.perm.getOpName(), objectId);
            isAuthorized = this.accessMgr.checkAccess(session.getSession(), finePerm);
            LOG.info("Fortress checkAccess objName: " + this.perm.getObjName() + " opName: " + this.perm.getOpName() + ", objId: " + finePerm.getObjId() + ", userId: " + session.getSession().getUserId() + " result: " + isAuthorized);
        }
        catch (SecurityException se) {
            String error = "Fortress SecurityException checkAccess objectName: " + this.perm.getObjName() + " opName: " + this.perm.getOpName() + ", objId: " + objectId + ", error=" + se;
            LOG.error(error);
        }
        return isAuthorized;
    }
}

