/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.draw;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawTextBoxElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.simple.PresentationDocument;
import org.odftoolkit.simple.draw.AbstractFrameContainer;
import org.odftoolkit.simple.draw.Frame;
import org.odftoolkit.simple.draw.FrameRectangle;
import org.odftoolkit.simple.draw.Textbox;
import org.odftoolkit.simple.draw.TextboxContainer;
import org.odftoolkit.simple.text.AbstractParagraphContainer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTextboxContainer
extends AbstractFrameContainer
implements TextboxContainer {
    @Override
    public Textbox addTextbox() {
        Textbox textbox = Textbox.newTextbox(this);
        return textbox;
    }

    @Override
    public boolean removeTextbox(Textbox box) {
        OdfElement containerElement = this.getFrameContainerElement();
        DrawFrameElement drawFrame = box.getDrawFrameElement();
        try {
            drawFrame.removeChild((Node)box.getOdfElement());
            if (!drawFrame.hasChildNodes()) {
                containerElement.removeChild((Node)box.getDrawFrameElement());
            }
        }
        catch (DOMException exception) {
            Logger.getLogger(AbstractParagraphContainer.class.getName()).log(Level.WARNING, exception.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Textbox> getTextboxIterator() {
        return new SimpleTextboxIterator(this);
    }

    @Override
    public Textbox addTextbox(FrameRectangle position) {
        Textbox textbox = Textbox.newTextbox(this);
        textbox.setRectangle(position);
        return textbox;
    }

    @Override
    public Textbox getTextboxByName(String name) {
        DrawTextBoxElement boxElement;
        Frame frame = this.getFrameByName(name);
        if (frame != null && (boxElement = (DrawTextBoxElement)OdfElement.findFirstChildNode(DrawTextBoxElement.class, (Node)frame.getDrawFrameElement())) != null) {
            Textbox box = Textbox.getInstanceof(boxElement);
            box.mFrameContainer = frame.mFrameContainer;
            return box;
        }
        return null;
    }

    @Override
    public List<Textbox> getTextboxByUsage(PresentationDocument.PresentationClass usage) {
        List<Frame> frameList = this.getFrameByPresentationclass(usage);
        if (frameList == null) {
            return null;
        }
        ArrayList<Textbox> al = new ArrayList<Textbox>();
        for (int i = 0; i < frameList.size(); ++i) {
            Frame frame = frameList.get(i);
            DrawTextBoxElement boxElement = (DrawTextBoxElement)OdfElement.findFirstChildNode(DrawTextBoxElement.class, (Node)frame.getDrawFrameElement());
            if (boxElement == null) continue;
            Textbox box = Textbox.getInstanceof(boxElement);
            box.mFrameContainer = frame.mFrameContainer;
            al.add(box);
        }
        return al;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleTextboxIterator
    implements Iterator<Textbox> {
        private OdfElement containerElement;
        private Textbox nextElement = null;
        private Textbox tempElement = null;

        private SimpleTextboxIterator(TextboxContainer container) {
            this.containerElement = container.getFrameContainerElement();
        }

        @Override
        public boolean hasNext() {
            this.tempElement = this.findNext(this.nextElement);
            return this.tempElement != null;
        }

        @Override
        public Textbox next() {
            if (this.tempElement != null) {
                this.nextElement = this.tempElement;
                this.tempElement = null;
            } else {
                this.nextElement = this.findNext(this.nextElement);
            }
            if (this.nextElement == null) {
                return null;
            }
            return this.nextElement;
        }

        @Override
        public void remove() {
            if (this.nextElement == null) {
                throw new IllegalStateException("please call next() first.");
            }
            this.containerElement.removeChild((Node)this.nextElement.getDrawFrameElement());
        }

        private Textbox findNext(Textbox thisBox) {
            DrawFrameElement nextFrame = null;
            nextFrame = thisBox == null ? (DrawFrameElement)OdfElement.findFirstChildNode(DrawFrameElement.class, (Node)this.containerElement) : (DrawFrameElement)OdfElement.findNextChildNode(DrawFrameElement.class, (Node)thisBox.getDrawFrameElement());
            if (nextFrame != null) {
                DrawTextBoxElement nextbox = (DrawTextBoxElement)OdfElement.findFirstChildNode(DrawTextBoxElement.class, (Node)nextFrame);
                return Textbox.getInstanceof(nextbox);
            }
            return null;
        }
    }
}

