/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.actions;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.CloseConnectionsRunnable;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionJob;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.connection.ui.actions.Messages;
import org.apache.directory.studio.connection.ui.actions.StudioAction;
import org.eclipse.jface.resource.ImageDescriptor;

public class CloseConnectionAction
extends StudioAction {
    @Override
    public void run() {
        new StudioConnectionJob(new StudioConnectionRunnableWithProgress[]{new CloseConnectionsRunnable(this.getSelectedConnections())}).execute();
    }

    @Override
    public String getText() {
        if (this.getSelectedConnections().length > 1) {
            return Messages.getString("CloseConnectionAction.CloseConnections");
        }
        return Messages.getString("CloseConnectionAction.CloseConnection");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return ConnectionUIPlugin.getDefault().getImageDescriptor("resources/icons/connection_disconnect.gif");
    }

    @Override
    public String getCommandId() {
        return null;
    }

    @Override
    public boolean isEnabled() {
        boolean canClose = false;
        Connection[] connectionArray = this.getSelectedConnections();
        int n = connectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Connection connection = connectionArray[n2];
            if (connection.getConnectionWrapper().isConnected()) {
                canClose = true;
                break;
            }
            ++n2;
        }
        return this.getSelectedConnections().length > 0 && canClose;
    }
}

