/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model;

import java.util.List;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.Messages;
import org.apache.directory.studio.schemaeditor.model.ProjectType;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.io.SchemaConnector;
import org.apache.directory.studio.schemaeditor.model.io.SchemaConnectorException;

public class Project {
    private ProjectType type;
    private String name;
    private Connection connection;
    private ProjectState state;
    private SchemaConnector schemaConnector;
    private SchemaHandler schemaHandler;
    private List<Schema> initialSchema;
    private boolean hasOnlineSchemaBeenFetched = false;

    public Project(ProjectType type, String name) {
        this.init(type, name, ProjectState.CLOSED);
    }

    public Project() {
        this.init(ProjectType.OFFLINE, null, ProjectState.CLOSED);
    }

    public Project(ProjectType type) {
        this.init(type, null, ProjectState.CLOSED);
    }

    private void init(ProjectType type, String name, ProjectState state) {
        this.type = type;
        this.name = name;
        this.state = state;
        this.schemaHandler = new SchemaHandler();
    }

    public ProjectType getType() {
        return this.type;
    }

    public void setType(ProjectType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProjectState getState() {
        return this.state;
    }

    public void setState(ProjectState state) {
        this.state = state;
    }

    public SchemaHandler getSchemaHandler() {
        return this.schemaHandler;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void fetchOnlineSchema(StudioProgressMonitor monitor) {
        if (!this.hasOnlineSchemaBeenFetched && this.connection != null && this.schemaConnector != null) {
            try {
                this.schemaConnector.importSchema(this, monitor);
            }
            catch (SchemaConnectorException e) {
                monitor.reportError((Exception)e);
            }
            if (this.initialSchema != null) {
                monitor.beginTask(Messages.getString("Project.AddingSchemaToProject"), this.initialSchema.size());
                for (Schema schema : this.initialSchema) {
                    this.getSchemaHandler().addSchema(schema);
                }
            }
            this.hasOnlineSchemaBeenFetched = true;
            monitor.done();
        }
    }

    public boolean hasOnlineSchemaBeenFetched() {
        return this.hasOnlineSchemaBeenFetched;
    }

    public List<Schema> getInitialSchema() {
        return this.initialSchema;
    }

    public void setInitialSchema(List<Schema> initialSchema) {
        this.initialSchema = initialSchema;
    }

    public SchemaConnector getSchemaConnector() {
        return this.schemaConnector;
    }

    public void setSchemaConnector(SchemaConnector schemaConnector) {
        this.schemaConnector = schemaConnector;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Project) {
            Project project = (Project)obj;
            if (!this.getName().equals(project.getName())) {
                return false;
            }
            if (!this.getType().equals((Object)project.getType())) {
                return false;
            }
            return this.getState().equals((Object)project.getState());
        }
        return super.equals(obj);
    }

    public static enum ProjectState {
        OPEN,
        CLOSED;

    }
}

