/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.dialogs.properties;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionServerType;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.jobs.ServerTypeDetector;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;
import org.apache.directory.studio.ldapbrowser.ui.dialogs.properties.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class RootDSEPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private TabFolder tabFolder;
    private TabItem infoTab;
    private TabItem controlsTab;
    private TabItem extensionsTab;
    private TabItem featuresTab;

    static IBrowserConnection getConnection(Object element) {
        IBrowserConnection browserConnection = null;
        if (element instanceof IAdaptable && (browserConnection = (IBrowserConnection)((IAdaptable)element).getAdapter(IBrowserConnection.class)) == null) {
            Connection connection = (Connection)((IAdaptable)element).getAdapter(Connection.class);
            browserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(connection);
        }
        return browserConnection;
    }

    protected Control createContents(Composite parent) {
        ConnectionServerType serverType;
        IBrowserConnection connection = RootDSEPropertyPage.getConnection(this.getElement());
        this.tabFolder = new TabFolder(parent, 128);
        RowLayout mainLayout = new RowLayout();
        mainLayout.fill = true;
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        this.tabFolder.setLayout((Layout)mainLayout);
        Composite infoComposite = new Composite((Composite)this.tabFolder, 0);
        GridLayout gl = new GridLayout(2, false);
        infoComposite.setLayout((Layout)gl);
        BaseWidgetUtils.createLabel((Composite)infoComposite, (String)Messages.getString("RootDSEPropertyPage.DirectoryType"), (int)1);
        Text typeText = BaseWidgetUtils.createWrappedLabeledText((Composite)infoComposite, (String)"-", (int)1, (int)150);
        if (connection != null && connection.getRootDSE() != null && (serverType = ServerTypeDetector.detectServerType((IRootDSE)connection.getRootDSE())) != null) {
            switch (serverType) {
                case APACHEDS: {
                    typeText.setText(Messages.getString("RootDSEPropertyPage.ApacheDirectoryServer"));
                    break;
                }
                case IBM_DIRECTORY_SERVER: {
                    typeText.setText(Messages.getString("RootDSEPropertyPage.IBMDirectory"));
                    break;
                }
                case IBM_SECUREWAY_DIRECTORY: {
                    typeText.setText(Messages.getString("RootDSEPropertyPage.IBMSecureWay"));
                    break;
                }
                case IBM_TIVOLI_DIRECTORY_SERVER: {
                    typeText.setText(Messages.getString("RootDSEPropertyPage.IBMTivoli"));
                    break;
                }
                case MICROSOFT_ACTIVE_DIRECTORY_2000: {
                    typeText.setText(Messages.getString("RootDSEPropertyPage.MSAD2000"));
                    break;
                }
                case MICROSOFT_ACTIVE_DIRECTORY_2003: {
                    typeText.setText(Messages.getString("RootDSEPropertyPage.MSAD2003"));
                    break;
                }
                case NETSCAPE: {
                    typeText.setText(Messages.getString("RootDSEPropertyPage.NetscapeDirectoryServer"));
                    break;
                }
                case NOVELL: {
                    typeText.setText(Messages.getString("RootDSEPropertyPage.NovellEDirectory"));
                    break;
                }
                case OPENLDAP: {
                    typeText.setText(Messages.getString("RootDSEPropertyPage.OpenLDAP"));
                    break;
                }
                case OPENLDAP_2_0: {
                    typeText.setText(Messages.getString("RootDSEPropertyPage.OpenLDAP20"));
                    break;
                }
                case OPENLDAP_2_1: {
                    typeText.setText(Messages.getString("RootDSEPropertyPage.OpenLDAP21"));
                    break;
                }
                case OPENLDAP_2_2: {
                    typeText.setText(Messages.getString("RootDSEPropertyPage.OpenLDAP22"));
                    break;
                }
                case OPENLDAP_2_3: {
                    typeText.setText(Messages.getString("RootDSEPropertyPage.OpenLDAP23"));
                    break;
                }
                case OPENLDAP_2_4: {
                    typeText.setText(Messages.getString("RootDSEPropertyPage.OpenLDAP24"));
                    break;
                }
                case SIEMENS_DIRX: {
                    typeText.setText(Messages.getString("RootDSEPropertyPage.SiemensDirX"));
                    break;
                }
                case SUN_DIRECTORY_SERVER: {
                    typeText.setText(Messages.getString("RootDSEPropertyPage.SunDirectoryServer"));
                }
            }
        }
        this.addInfo(connection, infoComposite, "vendorName", Messages.getString("RootDSEPropertyPage.VendorName"));
        this.addInfo(connection, infoComposite, "vendorVersion", Messages.getString("RootDSEPropertyPage.VendorVersion"));
        this.addInfo(connection, infoComposite, "supportedLDAPVersion", Messages.getString("RootDSEPropertyPage.SupportedLDAPVersion"));
        this.addInfo(connection, infoComposite, "supportedSASLMechanisms", Messages.getString("RootDSEPropertyPage.SupportedSASL"));
        this.infoTab = new TabItem(this.tabFolder, 0);
        this.infoTab.setText(Messages.getString("RootDSEPropertyPage.Info"));
        this.infoTab.setControl((Control)infoComposite);
        Composite controlsComposite = new Composite((Composite)this.tabFolder, 0);
        controlsComposite.setLayout((Layout)new GridLayout());
        Composite controlsComposite2 = BaseWidgetUtils.createColumnContainer((Composite)controlsComposite, (int)2, (int)1);
        this.addOidInfo(connection, controlsComposite2, "supportedControl");
        this.controlsTab = new TabItem(this.tabFolder, 0);
        this.controlsTab.setText(Messages.getString("RootDSEPropertyPage.Controls"));
        this.controlsTab.setControl((Control)controlsComposite);
        Composite extensionComposite = new Composite((Composite)this.tabFolder, 0);
        extensionComposite.setLayout((Layout)new GridLayout());
        Composite extensionComposite2 = BaseWidgetUtils.createColumnContainer((Composite)extensionComposite, (int)2, (int)1);
        this.addOidInfo(connection, extensionComposite2, "supportedExtension");
        this.extensionsTab = new TabItem(this.tabFolder, 0);
        this.extensionsTab.setText(Messages.getString("RootDSEPropertyPage.Extensions"));
        this.extensionsTab.setControl((Control)extensionComposite);
        Composite featureComposite = new Composite((Composite)this.tabFolder, 0);
        featureComposite.setLayout((Layout)new GridLayout());
        Composite featureComposite2 = BaseWidgetUtils.createColumnContainer((Composite)featureComposite, (int)2, (int)1);
        this.addOidInfo(connection, featureComposite2, "supportedFeatures");
        this.featuresTab = new TabItem(this.tabFolder, 0);
        this.featuresTab.setText(Messages.getString("RootDSEPropertyPage.Features"));
        this.featuresTab.setControl((Control)featureComposite);
        return this.tabFolder;
    }

    private void addOidInfo(IBrowserConnection browserConnection, Composite composite, String attributeType) {
        try {
            String[] values;
            String[] stringArray = values = browserConnection.getRootDSE().getAttribute(attributeType).getStringValues();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                String description = Utils.getOidDescription((String)value);
                if (description == null) {
                    description = "";
                }
                BaseWidgetUtils.createLabeledText((Composite)composite, (String)value, (int)1, (int)15);
                BaseWidgetUtils.createLabeledText((Composite)composite, (String)description, (int)1, (int)15);
                ++n2;
            }
        }
        catch (Exception exception) {}
    }

    private void addInfo(IBrowserConnection browserConnection, Composite composite, String attributeType, String labelName) {
        StringBuffer sb = new StringBuffer();
        try {
            String[] values = browserConnection.getRootDSE().getAttribute(attributeType).getStringValues();
            boolean isFirst = true;
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!isFirst) {
                    sb.append(BrowserCoreConstants.LINE_SEPARATOR);
                }
                sb.append(value);
                isFirst = false;
                ++n2;
            }
        }
        catch (Exception exception) {
            sb.append(Messages.getString("RootDSEPropertyPage.Dash"));
        }
        BaseWidgetUtils.createLabel((Composite)composite, (String)labelName, (int)1);
        BaseWidgetUtils.createWrappedLabeledText((Composite)composite, (String)sb.toString(), (int)1, (int)150);
    }
}

