/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.exceptions.DatabaseNotOpenException;
import org.apache.empire.db.expr.column.DBPreparable;
import org.apache.empire.dbms.DBMSHandler;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class DBAbstractFuncExpr
extends DBColumnExpr
implements DBPreparable {
    protected static final Logger log = LoggerFactory.getLogger(DBAbstractFuncExpr.class);
    protected final DBColumnExpr expr;
    protected final boolean isAggregate;
    protected final DataType dataType;

    public DBAbstractFuncExpr(DBColumnExpr expr, boolean isAggregate, DataType dataType) {
        this.expr = expr;
        this.isAggregate = isAggregate || expr.isAggregate();
        this.dataType = dataType;
    }

    protected abstract String getFunctionName();

    protected DBMSHandler getDbms() {
        Object db = this.expr.getDatabase();
        if (db == null) {
            throw new InvalidArgumentException("expr", this.expr);
        }
        Object dbms = ((DBDatabase)db).getDbms();
        if (dbms == null) {
            throw new DatabaseNotOpenException((DBDatabase)db);
        }
        return dbms;
    }

    public final DBDatabase getDatabase() {
        return this.expr.getDatabase();
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        return null;
    }

    @Override
    public String getName() {
        String exprName = this.expr.getName();
        String funcName = this.getFunctionName();
        return StringUtils.isNotEmpty(exprName) ? exprName + "_" + funcName : funcName;
    }

    @Override
    public DBRowSet getRowSet() {
        return this.expr.getRowSet();
    }

    @Override
    public DBColumn getUpdateColumn() {
        return this.expr.getUpdateColumn();
    }

    @Override
    public boolean isAggregate() {
        return this.isAggregate;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.expr.addReferencedColumns(list);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DBAbstractFuncExpr) {
            DBAbstractFuncExpr otherFunc = (DBAbstractFuncExpr)other;
            if (!this.expr.equals(otherFunc.expr)) {
                return false;
            }
            String tname = this.getFunctionName();
            String oname = otherFunc.getFunctionName();
            return StringUtils.compareEqual(tname, oname);
        }
        return false;
    }

    @Override
    public void prepareParams(DBCommand cmd, DBExpr parent) {
        if (this.expr instanceof DBPreparable) {
            ((DBPreparable)((Object)this.expr)).prepareParams(cmd, this);
        }
    }

    public final void addSQL(DBSQLBuilder sql, String template, Object[] params, long context) {
        int pos = 0;
        int prev = 0;
        int len = template.length();
        while (pos < len) {
            char c = template.charAt(pos);
            if (c == '?') {
                if (prev < pos) {
                    sql.append(template.substring(prev, pos));
                }
                this.expr.addSQL(sql, context & 0xFFFFFFFFFFFFFFF7L);
                prev = ++pos;
                continue;
            }
            if (c == '{') {
                char digit;
                int end;
                if (prev < pos) {
                    sql.append(template.substring(prev, pos));
                }
                for (end = ++pos; end < len && (digit = template.charAt(end)) >= '0' && digit <= '9'; ++end) {
                }
                if (end >= len) {
                    throw new InvalidArgumentException("template", template);
                }
                int iParam = Integer.parseInt(template.substring(pos, end));
                if (iParam < 0 || iParam >= params.length) {
                    throw new InvalidArgumentException("params", params);
                }
                for (end = ++pos; end < len && template.charAt(end) != '}'; ++end) {
                }
                if (end >= len) {
                    throw new InvalidArgumentException("template", template);
                }
                DataType paramDataType = this.expr.getDataType();
                if (template.charAt(pos) == ':') {
                    String typeName = template.substring(pos + 1, end);
                    paramDataType = StringUtils.isNotEmpty(typeName) && !typeName.equals("*") ? DataType.valueOf(typeName) : (typeName.equals("*") || params[iParam] == null || params[iParam] instanceof DBExpr ? DataType.UNKNOWN : DataType.fromJavaType(params[iParam].getClass()));
                }
                sql.appendValue(paramDataType, params[iParam], 7L, ",");
                prev = pos = end + 1;
                continue;
            }
            ++pos;
        }
        if (prev < len) {
            sql.append(template.substring(prev));
            if (prev == 0) {
                log.warn("No Placeholder found in template {}", (Object)template);
            }
        }
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem = XMLUtil.addElement(parent, "column");
        elem.setAttribute("name", this.getName());
        elem.setAttribute("function", this.getFunctionName());
        elem.setAttribute("dataType", this.getDataType().name());
        elem.setAttribute("aggregate", String.valueOf(this.isAggregate));
        DBColumn column = this.getUpdateColumn();
        if (column != null) {
            Element elemSource = XMLUtil.addElement(elem, "source");
            column.addXml(elemSource, flags);
        }
        if (this.attributes != null) {
            this.attributes.addXml(elem, flags);
        }
        if (this.options != null) {
            this.options.addXml(elem, this.dataType);
        }
        return elem;
    }
}

