/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.ModuleImpl;
import org.apache.felix.framework.util.Util;
import org.apache.felix.moduleloader.IModule;

class FindEntriesEnumeration
implements Enumeration {
    private final BundleImpl m_bundle;
    private final Enumeration[] m_enumerations;
    private final IModule[] m_modules;
    private int m_moduleIndex = 0;
    private final String m_path;
    private final String[] m_filePattern;
    private final boolean m_recurse;
    private Object m_next = null;

    public FindEntriesEnumeration(BundleImpl bundle, String path, String filePattern, boolean recurse) {
        int i;
        this.m_bundle = bundle;
        IModule bundleModule = this.m_bundle.getCurrentModule();
        IModule[] fragmentModules = ((ModuleImpl)bundleModule).getFragments();
        if (fragmentModules == null) {
            fragmentModules = new IModule[]{};
        }
        this.m_modules = new IModule[fragmentModules.length + 1];
        this.m_modules[0] = bundleModule;
        for (i = 0; i < fragmentModules.length; ++i) {
            this.m_modules[i + 1] = fragmentModules[i];
        }
        this.m_enumerations = new Enumeration[this.m_modules.length];
        for (i = 0; i < this.m_modules.length; ++i) {
            this.m_enumerations[i] = this.m_modules[i].getContent() != null ? this.m_modules[i].getContent().getEntries() : null;
        }
        this.m_recurse = recurse;
        if (path == null) {
            throw new IllegalArgumentException("The path for findEntries() cannot be null.");
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path.length() > 0 && path.charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        this.m_path = path;
        filePattern = filePattern == null ? "*" : filePattern;
        this.m_filePattern = Util.parseSubstring(filePattern);
        this.m_next = this.findNext();
    }

    public synchronized boolean hasMoreElements() {
        return this.m_next != null;
    }

    public synchronized Object nextElement() {
        if (this.m_next == null) {
            throw new NoSuchElementException("No more entry paths.");
        }
        Object last = this.m_next;
        this.m_next = this.findNext();
        return last;
    }

    private Object findNext() {
        if (this.m_enumerations == null) {
            return null;
        }
        while (this.m_moduleIndex < this.m_enumerations.length) {
            while (this.m_enumerations[this.m_moduleIndex] != null && this.m_enumerations[this.m_moduleIndex].hasMoreElements()) {
                String entryName = (String)this.m_enumerations[this.m_moduleIndex].nextElement();
                if (entryName.equals(this.m_path) || !entryName.startsWith(this.m_path)) continue;
                int idx = entryName.indexOf(47, this.m_path.length());
                if (!this.m_recurse && idx >= 0 && idx != entryName.length() - 1) continue;
                int endIdx = entryName.charAt(entryName.length() - 1) == '/' ? entryName.length() - 1 : entryName.length();
                int startIdx = entryName.charAt(entryName.length() - 1) == '/' ? entryName.lastIndexOf(47, endIdx - 1) + 1 : entryName.lastIndexOf(47, endIdx) + 1;
                String lastElement = entryName.substring(startIdx, endIdx);
                if (!Util.checkSubstring(this.m_filePattern, lastElement)) continue;
                return this.m_modules[this.m_moduleIndex].getEntry(entryName);
            }
            ++this.m_moduleIndex;
        }
        return null;
    }
}

