/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.config;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.karaf.shell.config.ConfigCommandSupport;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="config", name="update", description="Save and propagate changes from the configuration being edited.")
public class UpdateCommand
extends ConfigCommandSupport {
    @Option(name="-b", aliases={"--bypass-storage"}, multiValued=false, required=false, description="Do not store the configuration in a properties file, but feed it directly to ConfigAdmin")
    private boolean bypassStorage;
    private File storage;

    public File getStorage() {
        return this.storage;
    }

    public void setStorage(File storage) {
        this.storage = storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(ConfigurationAdmin admin) throws Exception {
        Dictionary props = this.getEditedProps();
        if (props == null) {
            System.err.println("No configuration is being edited. Run the edit command first");
        } else if (!this.bypassStorage && this.storage != null) {
            Properties p = new Properties();
            Enumeration keys = props.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if ("service.pid".equals(key) || "felix.fileinstall.filename".equals(key)) continue;
                p.put(key, props.get(key));
            }
            this.storage.mkdirs();
            String pid = (String)this.session.get("ConfigCommand.PID");
            FileOutputStream os = new FileOutputStream(new File(this.storage, pid + ".cfg"));
            try {
                p.store(os, null);
            }
            finally {
                os.close();
            }
            this.session.put("ConfigCommand.PID", null);
            this.session.put("ConfigCommand.Props", null);
        } else {
            String pid = (String)this.session.get("ConfigCommand.PID");
            Configuration cfg = admin.getConfiguration(pid, null);
            cfg.update(props);
            this.session.put("ConfigCommand.PID", null);
            this.session.put("ConfigCommand.Props", null);
        }
    }
}

