/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.tracker;

import org.apache.aries.util.tracker.AbstractBundleTrackerCustomizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.framework.CompositeBundle;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public abstract class MultiBundleTracker
extends AbstractBundleTrackerCustomizer {
    private static final int COMPOSITE_BUNDLE_MASK = 56;
    private final BundleTracker tracker;

    public MultiBundleTracker(BundleContext context, int stateMask) {
        if ((stateMask & 0x38) != 56) {
            throw new IllegalArgumentException();
        }
        this.tracker = MultiBundleTracker.areMultipleFrameworksAvailable(context) ? new InternalBundleTracker(context, stateMask) : new BundleTracker(context, stateMask, (BundleTrackerCustomizer)this);
    }

    private static boolean areMultipleFrameworksAvailable(BundleContext context) {
        ServiceReference sr = context.getServiceReference("org.osgi.service.framework.CompositeBundleFactory");
        return sr != null;
    }

    public void open() {
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    private class InternalBundleTracker
    extends BundleTracker {
        private final int mask;

        public InternalBundleTracker(BundleContext context, int stateMask) {
            super(context, stateMask, null);
            this.mask = stateMask;
        }

        public Object addingBundle(Bundle b, BundleEvent event) {
            Object o = null;
            if (b instanceof CompositeBundle) {
                MultiBundleTracker.this.customizedProcessBundle((BundleTrackerCustomizer)this, b, event, this.mask);
                o = b;
            } else {
                o = MultiBundleTracker.this.addingBundle(b, event);
            }
            return o;
        }

        public void modifiedBundle(Bundle b, BundleEvent event, Object object) {
            if (b instanceof CompositeBundle) {
                MultiBundleTracker.this.customizedProcessBundle((BundleTrackerCustomizer)this, b, event, this.mask);
            } else {
                MultiBundleTracker.this.modifiedBundle(b, event, object);
            }
        }

        public void removedBundle(Bundle b, BundleEvent event, Object object) {
            if (!(b instanceof CompositeBundle)) {
                MultiBundleTracker.this.removedBundle(b, event, object);
            }
        }
    }
}

