/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.prefs.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.felix.prefs.BackingStore;
import org.apache.felix.prefs.BackingStoreManager;
import org.apache.felix.prefs.PreferencesImpl;
import org.apache.felix.prefs.impl.DataFileBackingStoreImpl;
import org.apache.felix.prefs.impl.PreferencesServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.util.tracker.ServiceTracker;

public class PreferencesManager
implements BundleActivator,
BundleListener,
ServiceFactory,
BackingStoreManager {
    protected final Map services = new HashMap();
    protected BundleContext context;
    protected ServiceTracker storeTracker;
    protected ServiceTracker logTracker;
    protected BackingStore defaultStore;
    protected int storeTrackingCount = -1;
    static /* synthetic */ Class class$org$osgi$service$log$LogService;
    static /* synthetic */ Class class$org$apache$felix$prefs$BackingStore;
    static /* synthetic */ Class class$org$osgi$service$prefs$PreferencesService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16) {
            Long bundleId = new Long(event.getBundle().getBundleId());
            Map map = this.services;
            synchronized (map) {
                try {
                    this.getStore().remove(bundleId);
                }
                catch (BackingStoreException ignore) {
                    // empty catch block
                }
                this.services.remove(bundleId);
            }
        }
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.logTracker = new ServiceTracker(context, (class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = PreferencesManager.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName(), null);
        this.logTracker.open();
        this.storeTracker = new ServiceTracker(context, (class$org$apache$felix$prefs$BackingStore == null ? (class$org$apache$felix$prefs$BackingStore = PreferencesManager.class$("org.apache.felix.prefs.BackingStore")) : class$org$apache$felix$prefs$BackingStore).getName(), null);
        this.storeTracker.open();
        context.addBundleListener((BundleListener)this);
        context.registerService((class$org$osgi$service$prefs$PreferencesService == null ? (class$org$osgi$service$prefs$PreferencesService = PreferencesManager.class$("org.osgi.service.prefs.PreferencesService")) : class$org$osgi$service$prefs$PreferencesService).getName(), (Object)this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        Map map = this.services;
        synchronized (map) {
            Iterator i = this.services.values().iterator();
            while (i.hasNext()) {
                PreferencesServiceImpl service = (PreferencesServiceImpl)i.next();
                this.save(service);
            }
            this.services.clear();
        }
        if (this.storeTracker != null) {
            this.storeTracker.close();
            this.storeTracker = null;
        }
        this.defaultStore = null;
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
        this.context = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(Bundle bundle, ServiceRegistration reg) {
        Long bundleId = new Long(bundle.getBundleId());
        Map map = this.services;
        synchronized (map) {
            PreferencesServiceImpl service = (PreferencesServiceImpl)this.services.get(bundleId);
            if (service == null) {
                service = new PreferencesServiceImpl(bundleId, this);
                this.services.put(bundleId, service);
            }
            return service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetService(Bundle bundle, ServiceRegistration reg, Object s) {
        Long bundleId = new Long(bundle.getBundleId());
        Map map = this.services;
        synchronized (map) {
            PreferencesServiceImpl service = (PreferencesServiceImpl)this.services.get(bundleId);
            if (service != null) {
                this.save(service);
            }
        }
    }

    protected void save(PreferencesServiceImpl service) {
        Iterator i = service.getAllPreferences().iterator();
        while (i.hasNext()) {
            PreferencesImpl prefs = (PreferencesImpl)i.next();
            try {
                this.getStore().store(prefs);
            }
            catch (BackingStoreException ignore) {}
        }
    }

    protected void log(int level, String message, Throwable t) {
        LogService log = (LogService)this.logTracker.getService();
        if (log != null) {
            log.log(level, message, t);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackingStore getStore() {
        int currentCount = this.storeTracker.getTrackingCount();
        BackingStore service = (BackingStore)this.storeTracker.getService();
        if (service != null && this.storeTrackingCount < currentCount) {
            this.storeTrackingCount = currentCount;
            this.cleanupStore(service);
        }
        if (service == null) {
            if (this.defaultStore == null) {
                PreferencesManager preferencesManager = this;
                synchronized (preferencesManager) {
                    if (this.defaultStore == null) {
                        this.defaultStore = new DataFileBackingStoreImpl(this.context);
                        this.cleanupStore(this.defaultStore);
                    }
                }
            }
            service = this.defaultStore;
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupStore(BackingStore store) {
        Long[] availableBundleIds = store.availableBundles();
        Map map = this.services;
        synchronized (map) {
            for (int i = 0; i < availableBundleIds.length; ++i) {
                Long bundleId = availableBundleIds[i];
                Bundle bundle = this.context.getBundle(bundleId.longValue());
                if (bundle != null && bundle.getState() != 1) continue;
                try {
                    store.remove(bundleId);
                    continue;
                }
                catch (BackingStoreException ignore) {
                    // empty catch block
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

