/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.maven.nativeimage;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import org.apache.felix.atomos.maven.LauncherBuilderUtil;
import org.apache.felix.atomos.maven.configs.MavenClassPathConfig;
import org.apache.felix.atomos.maven.configs.MavenClasspathMavenConfig;
import org.apache.felix.atomos.maven.configs.MavenIndexConfig;
import org.apache.felix.atomos.maven.configs.MavenNativeImageConfig;
import org.apache.felix.atomos.utils.api.Config;
import org.apache.felix.atomos.utils.api.Launcher;
import org.apache.felix.atomos.utils.api.LauncherBuilder;
import org.apache.felix.atomos.utils.core.plugins.ComponentDescriptionPlugin;
import org.apache.felix.atomos.utils.core.plugins.GogoPlugin;
import org.apache.felix.atomos.utils.core.plugins.OsgiDTOPlugin;
import org.apache.felix.atomos.utils.core.plugins.ResourcePlugin;
import org.apache.felix.atomos.utils.core.plugins.activator.InvocatingBundleActivatorPlugin;
import org.apache.felix.atomos.utils.core.plugins.activator.ReflectionBundleActivatorPlugin;
import org.apache.felix.atomos.utils.core.plugins.collector.PathCollectorPlugin;
import org.apache.felix.atomos.utils.core.plugins.collector.PathCollectorPluginConfig;
import org.apache.felix.atomos.utils.core.plugins.finaliser.ni.NativeImageBuilderConfig;
import org.apache.felix.atomos.utils.core.plugins.finaliser.ni.NativeImagePlugin;
import org.apache.felix.atomos.utils.core.plugins.index.IndexOutputType;
import org.apache.felix.atomos.utils.core.plugins.index.IndexPlugin;
import org.apache.felix.atomos.utils.core.plugins.index.IndexPluginConfig;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="atomos-native-image", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class NativeImageMojo
extends AbstractMojo {
    @Parameter(required=false, readonly=false)
    public MavenNativeImageConfig nativeImage;
    @Parameter(defaultValue="${project}", required=true, readonly=false)
    private MavenProject project;
    @Parameter(required=false, readonly=false)
    MavenClassPathConfig classpath;

    public void execute() throws MojoExecutionException {
        if (this.nativeImage.applicationName == null) {
            this.nativeImage.applicationName = this.project.getArtifactId();
        }
        try {
            if (this.classpath == null) {
                MavenClassPathConfig classPathConfig = new MavenClassPathConfig();
                MavenClasspathMavenConfig mavenIndexMojoConfig = new MavenClasspathMavenConfig();
                classPathConfig.maven = List.of(mavenIndexMojoConfig);
                this.classpath = classPathConfig;
            }
            File outputDirectory = Paths.get(this.project.getBuild().getDirectory(), new String[0]).toFile();
            Files.createDirectories(outputDirectory.toPath(), new FileAttribute[0]);
            LauncherBuilder builder = Launcher.builder();
            Optional.ofNullable(this.classpath.paths).orElse(List.of()).forEach(cc -> {
                PathCollectorPluginConfig pc = LauncherBuilderUtil.processClasspathFile(cc);
                builder.addPlugin(PathCollectorPlugin.class, (Object)pc);
            });
            Optional.ofNullable(this.classpath.maven).orElse(List.of()).forEach(cc -> {
                PathCollectorPluginConfig pc = LauncherBuilderUtil.processClasspathMaven(this.project, cc);
                builder.addPlugin(PathCollectorPlugin.class, (Object)pc);
            });
            MavenIndexConfig mic = new MavenIndexConfig();
            mic.indexOutputType = IndexOutputType.JAR;
            IndexPluginConfig ic = LauncherBuilderUtil.processIndex(mic, this.project);
            builder.addPlugin(IndexPlugin.class, (Object)ic);
            Config cfg = new Config(){};
            builder.addPlugin(ReflectionBundleActivatorPlugin.class, (Object)cfg).addPlugin(ComponentDescriptionPlugin.class, (Object)cfg).addPlugin(GogoPlugin.class, (Object)cfg).addPlugin(InvocatingBundleActivatorPlugin.class, (Object)cfg).addPlugin(OsgiDTOPlugin.class, (Object)cfg).addPlugin(ResourcePlugin.class, (Object)cfg);
            if (this.nativeImage.outputDirectory == null) {
                this.nativeImage.outputDirectory = outputDirectory;
            }
            NativeImageBuilderConfig nic = LauncherBuilderUtil.processNativeImageConfig(this.nativeImage, this.project);
            builder.addPlugin(NativeImagePlugin.class, (Object)nic);
            builder.build().execute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error", e);
        }
    }
}

