/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.impl.base;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.atomos.AtomosContent;
import org.apache.felix.atomos.AtomosLayer;
import org.apache.felix.atomos.impl.base.AtomosBase;
import org.apache.felix.service.command.Descriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;

public class AtomosCommands {
    public static String[] functions = new String[]{"list", "install", "uninstall"};
    private final AtomosBase runtime;

    public AtomosCommands(AtomosBase runtime) {
        this.runtime = runtime;
    }

    public ServiceRegistration<AtomosCommands> register(BundleContext context) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("osgi.command.function", functions);
        props.put("osgi.command.scope", "atomos");
        return context.registerService(AtomosCommands.class, (Object)this, props);
    }

    @Descriptor(value="List all layers")
    public void list() {
        AtomosLayer bl = this.runtime.getBootLayer();
        this.layers(bl.getParents().stream().findFirst().orElse(bl), new HashSet<AtomosLayer>());
    }

    private void layers(AtomosLayer layer, Set<AtomosLayer> visited) {
        if (visited.add(layer)) {
            System.out.println(layer.toString());
            Set<AtomosContent> contents = layer.getAtomosContents();
            if (!contents.isEmpty()) {
                System.out.println(" BUNDLES:");
                for (AtomosContent content : contents) {
                    Bundle b = this.runtime.getBundle(content);
                    System.out.println("  " + content.getSymbolicName() + this.getState(b));
                }
            }
            for (AtomosLayer child : layer.getChildren()) {
                this.layers(child, visited);
            }
        }
    }

    private String getState(Bundle b) {
        if (b == null) {
            return " NOT_INSTALLED";
        }
        switch (b.getState()) {
            case 2: {
                return " INSTALLED";
            }
            case 4: {
                return " RESOLVED";
            }
            case 8: {
                return " STARTING";
            }
            case 32: {
                return " ACTIVE";
            }
            case 16: {
                return " STOPPING";
            }
            case 1: {
                return " UNINSTALLED";
            }
        }
        return " UNKNOWN";
    }

    @Descriptor(value="Install a new layer")
    public void install(@Descriptor(value="Name of the layer") String name, @Descriptor(value="LoaderType of the layer [OSGI, SINGLE, MANY]") String loaderType, @Descriptor(value="Directory containing bundle JARs to install into the layer") File moduleDir) throws BundleException {
        if (!moduleDir.isDirectory()) {
            System.out.println("The specified path is not a directory: " + moduleDir.getAbsolutePath());
            return;
        }
        Optional<AtomosLayer.LoaderType> oLoaderType = Stream.of(AtomosLayer.LoaderType.values()).filter(e -> e.name().equalsIgnoreCase(loaderType)).findAny();
        if (oLoaderType.isEmpty()) {
            String v = Stream.of(AtomosLayer.LoaderType.values()).map(Enum::name).collect(Collectors.joining(", "));
            System.out.printf("The specified loaderType is not valid. Use one of %s", v);
            return;
        }
        AtomosLayer layer = this.runtime.getBootLayer().addLayer(name, oLoaderType.get(), moduleDir.toPath());
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (AtomosContent atomosBundle : layer.getAtomosContents()) {
            bundles.add(atomosBundle.install());
        }
        for (Bundle b : bundles) {
            b.start();
        }
        this.layers(layer, new HashSet<AtomosLayer>());
    }

    @Descriptor(value="Uninstall the layer with the given id")
    public void uninstall(@Descriptor(value="Id of the layer") long id) throws BundleException {
        AtomosBase.AtomosLayerBase layer = this.runtime.getById(id);
        if (layer == null) {
            System.out.println("No Atomos Layer with ID: " + id);
        } else {
            try {
                layer.uninstall();
                System.out.printf("Sucessfully uninstalled Atomos Layer \"%s\" with ID: %s", layer.getName(), id);
            }
            catch (Exception e) {
                System.out.printf("Failing to uninstall this Atomos Layer \"%s\" with ID: %s", layer.getName(), id);
                throw e;
            }
        }
    }
}

