/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.utils.core.plugins;

import java.lang.reflect.Constructor;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.felix.atomos.utils.api.Config;
import org.apache.felix.atomos.utils.api.Context;
import org.apache.felix.atomos.utils.api.plugin.ComponentDescription;
import org.apache.felix.atomos.utils.api.plugin.ComponentMetaDataPlugin;
import org.apache.felix.atomos.utils.api.plugin.ReferenceDescription;

public class ComponentDescriptionPlugin
implements ComponentMetaDataPlugin<Config> {
    public void doComponentMetaData(ComponentDescription c, Context context, ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClass(c.implementationClass());
            Optional.ofNullable(c.activate()).ifPresent(m -> context.addReflectionMethod(m, clazz));
            Optional.ofNullable(c.modified()).ifPresent(m -> context.addReflectionMethod(m, clazz));
            Optional.ofNullable(c.deactivate()).ifPresent(m -> context.addReflectionMethod(m, clazz));
            if (c.activationFields() != null) {
                for (Object fName : c.activationFields()) {
                    context.addReflectionField((String)fName, clazz);
                }
            }
            String[] constrParams = new String[c.numberOfConstructorParameters()];
            if (c.references() != null && !c.references().isEmpty()) {
                for (ReferenceDescription r : c.references()) {
                    Optional.ofNullable(r.parameter()).ifPresent(i -> {
                        constrParams[i.intValue()] = r.interfaceName();
                    });
                    Optional.ofNullable(r.field()).ifPresent(f -> context.addReflectionField(f, clazz));
                    Optional.ofNullable(r.bind()).ifPresent(m -> context.addReflectionMethod(m, clazz));
                    Optional.ofNullable(r.updated()).ifPresent(m -> context.addReflectionMethod(m, clazz));
                    Optional.ofNullable(r.unbind()).ifPresent(m -> context.addReflectionMethod(m, clazz));
                    Optional.ofNullable(r.interfaceName()).ifPresent(i -> context.addReflectionClass(i));
                }
            }
            boolean foundConstructor = false;
            if (c.numberOfConstructorParameters() == 0) {
                context.addReflectionConstructorDefault(clazz);
                foundConstructor = true;
            } else {
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    if (constructor.getParameterCount() != c.numberOfConstructorParameters()) continue;
                    boolean match = true;
                    for (int j = 0; j < constructor.getParameterCount(); ++j) {
                        String p2 = constructor.getParameters()[j].getType().getName();
                        String s = constrParams[j];
                        if (s == null || p2.equals(s)) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    String[] ps = (String[])Stream.of(constructor.getParameters()).map(p -> p.getType().getName()).toArray(String[]::new);
                    context.addReflectionConstructor(clazz, ps);
                    foundConstructor = true;
                    break;
                }
                if (!foundConstructor) {
                    context.addReflectionConstructorAllPublic(clazz);
                }
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void init(Config config) {
    }
}

