/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.spi.AbstractAction;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.log.LogService;

public class StopBundleCommand
extends Command {
    protected void doExecute(DeploymentSessionImpl session) throws Exception {
        LogService log = session.getLog();
        AbstractDeploymentPackage target = session.getTargetAbstractDeploymentPackage();
        BundleInfoImpl[] bundleInfos = target.getOrderedBundleInfos();
        for (int i = 0; i < bundleInfos.length; ++i) {
            if (this.isCancelled()) {
                throw new DeploymentException(401);
            }
            String symbolicName = bundleInfos[i].getSymbolicName();
            Bundle bundle = target.getBundle(symbolicName);
            if (bundle != null) {
                if (this.omitBundleStop(session, symbolicName)) continue;
                if (StopBundleCommand.isFragmentBundle(bundle)) {
                    log.log(3, "Skipping fragment bundle '" + symbolicName + "'");
                    continue;
                }
                this.addRollback(new StartBundleRunnable(session, bundle));
                try {
                    bundle.stop();
                }
                catch (Exception e) {
                    log.log(2, "Could not stop bundle '" + symbolicName + "'", (Throwable)e);
                }
                continue;
            }
            log.log(2, "Could not stop bundle '" + symbolicName + "' because it was not present in the framework");
        }
    }

    private boolean omitBundleStop(DeploymentSessionImpl session, String symbolicName) {
        boolean stopUnaffectedBundles = session.getConfiguration().isStopUnaffectedBundles();
        if (stopUnaffectedBundles) {
            return false;
        }
        BundleInfoImpl sourceBundleInfo = session.getSourceAbstractDeploymentPackage().getBundleInfoByName(symbolicName);
        BundleInfoImpl targetBundleInfo = session.getTargetAbstractDeploymentPackage().getBundleInfoByName(symbolicName);
        boolean fixPackageMissing = sourceBundleInfo != null && sourceBundleInfo.isMissing();
        boolean sameVersion = targetBundleInfo != null && sourceBundleInfo != null && targetBundleInfo.getVersion().equals((Object)sourceBundleInfo.getVersion());
        return fixPackageMissing || sameVersion;
    }

    private static class StartBundleRunnable
    extends AbstractAction {
        private final DeploymentSessionImpl m_session;
        private final Bundle m_bundle;

        public StartBundleRunnable(DeploymentSessionImpl session, Bundle bundle) {
            this.m_session = session;
            this.m_bundle = bundle;
        }

        protected void doRun() throws Exception {
            this.m_bundle.start();
        }

        protected void onFailure(Exception e) {
            this.m_session.getLog().log(2, "Failed to start bundle '" + this.m_bundle.getSymbolicName() + "'", (Throwable)e);
        }
    }
}

