/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The SF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package org.apache.felix.hc.api;

import static org.apache.felix.hc.api.FormattingResultLog.bytesHumanReadable;
import static org.apache.felix.hc.api.FormattingResultLog.msHumanReadable;
import static org.junit.Assert.assertEquals;

import org.junit.Test;

public class FormattingResultLogTest {

    @Test
    public void testBytesHumanReadable() {
        assertEquals("5.0MB", bytesHumanReadable(5d*1024*1024));
        assertEquals("2.0GB", bytesHumanReadable(2d*1024*1024*1024));
        assertEquals("706.1kB", bytesHumanReadable(722998));
    }

    @Test
    public void testMSHumanReadable() {
        assertEquals("320ms", msHumanReadable(320));
        assertEquals("5sec", msHumanReadable(5*1000));
        assertEquals("1min", msHumanReadable(60*1000));
        assertEquals("1.2min", msHumanReadable(72*1000));
        assertEquals("3h", msHumanReadable(3*60*60*1000));
    }

}
