/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.handler.AbstractHandler;
import org.apache.felix.http.base.internal.handler.FilterConfigImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterHandler
extends AbstractHandler
implements Comparable<FilterHandler> {
    private final Filter filter;
    private final Pattern regex;
    private final int ranking;

    public FilterHandler(ExtServletContext context, Filter filter, String pattern, int ranking, String name) {
        super(context, name);
        this.filter = filter;
        this.ranking = ranking;
        this.regex = Pattern.compile(pattern);
    }

    @Override
    public int compareTo(FilterHandler other) {
        if (other.ranking == this.ranking) {
            return 0;
        }
        return other.ranking > this.ranking ? 1 : -1;
    }

    @Override
    public void destroy() {
        this.filter.destroy();
    }

    public Filter getFilter() {
        return this.filter;
    }

    public String getPattern() {
        return this.regex.toString();
    }

    public int getRanking() {
        return this.ranking;
    }

    public void handle(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws ServletException, IOException {
        boolean matches = this.matches(req.getPathInfo());
        if (matches) {
            this.doHandle(req, res, chain);
        } else {
            chain.doFilter(req, res);
        }
    }

    @Override
    public void init() throws ServletException {
        this.filter.init(new FilterConfigImpl(this.getName(), this.getContext(), this.getInitParams()));
    }

    public boolean matches(String uri) {
        if (uri == null) {
            uri = "/";
        }
        return this.regex.matcher(uri).matches();
    }

    final void doHandle(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws ServletException, IOException {
        if (this.getContext().handleSecurity(req, res)) {
            this.filter.doFilter(req, res, chain);
        } else if (!res.isCommitted() && res.getStatus() == 200) {
            res.sendError(403);
        }
    }

    @Override
    protected Object getSubject() {
        return this.filter;
    }
}

