/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.inventoryprinter.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.http.inventoryprinter.impl.HttpInventoryPrinter;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.servlet.runtime.HttpServiceRuntime;
import org.osgi.service.servlet.whiteboard.annotations.RequireHttpWhiteboard;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Header(name="Bundle-Activator", value="${@class}")
@RequireHttpWhiteboard
public class Activator
implements BundleActivator {
    private volatile ServiceTracker<HttpServiceRuntime, HttpServiceRuntime> tracker;
    private volatile ServiceRegistration<InventoryPrinter> serviceReg;

    private void register(BundleContext context, HttpServiceRuntime runtime) {
        HttpInventoryPrinter plugin = new HttpInventoryPrinter(context, runtime);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("felix.inventory.printer.name", "httpservice");
        ((Dictionary)props).put("felix.inventory.printer.title", "HTTP Service");
        ((Dictionary)props).put("felix.inventory.printer.format", new String[]{Format.JSON.toString(), Format.TEXT.toString()});
        this.serviceReg = context.registerService(InventoryPrinter.class, (Object)plugin, props);
    }

    public void start(final BundleContext context) throws Exception {
        ServiceTracker tracker = new ServiceTracker(context, HttpServiceRuntime.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<HttpServiceRuntime, HttpServiceRuntime>(){

            public HttpServiceRuntime addingService(ServiceReference<HttpServiceRuntime> reference) {
                HttpServiceRuntime runtime = (HttpServiceRuntime)context.getService(reference);
                if (runtime != null) {
                    Activator.this.register(context, runtime);
                }
                return runtime;
            }

            public void modifiedService(ServiceReference<HttpServiceRuntime> reference, HttpServiceRuntime service) {
            }

            public void removedService(ServiceReference<HttpServiceRuntime> reference, HttpServiceRuntime service) {
                if (Activator.this.serviceReg != null) {
                    try {
                        Activator.this.serviceReg.unregister();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    Activator.this.serviceReg = null;
                }
            }
        });
        tracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }
}

