/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.whiteboard.internal.tracker;

import org.apache.felix.http.whiteboard.internal.manager.ExtenderManager;
import org.apache.felix.http.whiteboard.internal.tracker.AbstractTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class FilterTracker
extends AbstractTracker<javax.servlet.Filter> {
    private final ExtenderManager manager;

    private static Filter createFilter(BundleContext btx) {
        try {
            return btx.createFilter(String.format("(&(objectClass=%s)(%s=*))", javax.servlet.Filter.class.getName(), "pattern"));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
    }

    public FilterTracker(BundleContext context, ExtenderManager manager) {
        super(context, FilterTracker.createFilter(context));
        this.manager = manager;
    }

    @Override
    protected void added(javax.servlet.Filter service, ServiceReference<javax.servlet.Filter> ref) {
        this.logDeprecationWarning("Filter", service, ref);
        this.manager.addFilter(service, ref);
    }

    @Override
    protected void removed(javax.servlet.Filter service, ServiceReference<javax.servlet.Filter> ref) {
        this.manager.removeFilter(ref);
    }
}

