/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.parser;

import org.apache.felix.ipojo.metadata.Element;

public class FieldMetadata {
    private String m_name;
    private String m_type;

    FieldMetadata(Element metadata) {
        this.m_name = metadata.getAttribute("name");
        this.m_type = metadata.getAttribute("type");
    }

    public FieldMetadata(String field, String type) {
        this.m_name = field;
        this.m_type = type;
    }

    public String getFieldName() {
        return this.m_name;
    }

    public String getFieldType() {
        return this.m_type;
    }

    public static String getReflectionType(String type) {
        if (type.endsWith("[]") && type.indexOf(46) == -1) {
            int index = type.indexOf(91);
            return '[' + FieldMetadata.getInternalPrimitiveType(type.substring(0, index));
        }
        if (type.endsWith("[]") && type.indexOf(46) != -1) {
            int index = type.indexOf(91);
            return "[L" + type.substring(0, index) + ";";
        }
        return type;
    }

    public static String getInternalPrimitiveType(String string) {
        if (string.equalsIgnoreCase("boolean")) {
            return "Z";
        }
        if (string.equalsIgnoreCase("char")) {
            return "C";
        }
        if (string.equalsIgnoreCase("byte")) {
            return "B";
        }
        if (string.equalsIgnoreCase("short")) {
            return "S";
        }
        if (string.equalsIgnoreCase("int")) {
            return "I";
        }
        if (string.equalsIgnoreCase("float")) {
            return "F";
        }
        if (string.equalsIgnoreCase("long")) {
            return "J";
        }
        if (string.equalsIgnoreCase("double")) {
            return "D";
        }
        return null;
    }

    public static String getPrimitiveTypeByClass(Class clazz) {
        if (clazz.equals(Boolean.TYPE)) {
            return "boolean";
        }
        if (clazz.equals(Character.TYPE)) {
            return "char";
        }
        if (clazz.equals(Byte.TYPE)) {
            return "byte";
        }
        if (clazz.equals(Short.TYPE)) {
            return "short";
        }
        if (clazz.equals(Integer.TYPE)) {
            return "int";
        }
        if (clazz.equals(Float.TYPE)) {
            return "float";
        }
        if (clazz.equals(Long.TYPE)) {
            return "long";
        }
        if (clazz.equals(Double.TYPE)) {
            return "double";
        }
        return null;
    }
}

