/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.component;

import aQute.bnd.component.AnnotationReader;
import aQute.lib.osgi.Analyzer;
import aQute.lib.tag.Tag;
import aQute.libg.version.Version;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceDef {
    Version version;
    String name;
    String interfce;
    ReferenceCardinality cardinality;
    ReferencePolicy policy;
    String target;
    String bind;
    String unbind;
    String modified;

    ReferenceDef() {
    }

    public void prepare(Analyzer analyzer) {
        if (this.name == null) {
            analyzer.error("No name for a reference", new Object[0]);
        }
        if (this.version == null) {
            this.version = AnnotationReader.V1_1;
        }
    }

    public Tag getTag() {
        Tag ref = new Tag("reference", new Object[0]);
        ref.addAttribute("name", this.name);
        if (this.cardinality != null) {
            ref.addAttribute("cardinality", this.p(this.cardinality));
        }
        if (this.policy != null) {
            ref.addAttribute("policy", this.p(this.policy));
        }
        if (this.interfce != null) {
            ref.addAttribute("interface", this.interfce);
        }
        if (this.target != null) {
            ref.addAttribute("target", this.target);
        }
        if (this.bind != null) {
            ref.addAttribute("bind", this.bind);
        }
        if (this.unbind != null) {
            ref.addAttribute("unbind", this.unbind);
        }
        if (this.modified != null) {
            ref.addAttribute("modified", this.modified);
            this.version = this.max(this.version, AnnotationReader.V1_2);
        }
        return ref;
    }

    private String p(ReferencePolicy policy) {
        switch (policy) {
            case DYNAMIC: {
                return "dynamic";
            }
            case STATIC: {
                return "static";
            }
        }
        return policy.toString();
    }

    private String p(ReferenceCardinality crd) {
        switch (crd) {
            case AT_LEAST_ONE: {
                return "1..n";
            }
            case MANDATORY: {
                return "1..1";
            }
            case MULTIPLE: {
                return "0..n";
            }
            case OPTIONAL: {
                return "0..1";
            }
        }
        return crd.toString();
    }

    private <T extends Comparable<T>> T max(T a, T b) {
        int n = a.compareTo(b);
        if (n >= 0) {
            return a;
        }
        return b;
    }

    public String toString() {
        return this.name;
    }
}

